/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;

public class FrameUnitVector3D
implements FrameUnitVector3DBasics,
Settable<FrameUnitVector3D> {
    private ReferenceFrame referenceFrame;
    private final UnitVector3D vector = new UnitVector3D();

    public FrameUnitVector3D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameUnitVector3D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameUnitVector3D(ReferenceFrame referenceFrame, double x, double y, double z) {
        this.setIncludingFrame(referenceFrame, x, y, z);
    }

    public FrameUnitVector3D(ReferenceFrame referenceFrame, double[] vectorArray) {
        this.setIncludingFrame(referenceFrame, vectorArray);
    }

    public FrameUnitVector3D(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple3DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple3DReadOnly);
    }

    public FrameUnitVector3D(ReferenceFrame referenceFrame, Tuple2DReadOnly tuple2DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple2DReadOnly, 0.0);
    }

    public FrameUnitVector3D(FrameTuple2DReadOnly frameTuple2DReadOnly) {
        this.setIncludingFrame(frameTuple2DReadOnly, 0.0);
    }

    public FrameUnitVector3D(FrameTuple3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void absolute() {
        this.vector.absolute();
    }

    public void negate() {
        this.vector.negate();
    }

    public void normalize() {
        this.vector.normalize();
    }

    public void markAsDirty() {
        this.vector.markAsDirty();
    }

    public boolean isDirty() {
        return this.vector.isDirty();
    }

    public void set(FrameUnitVector3D other) {
        FrameUnitVector3DBasics.super.set((FrameUnitVector3DReadOnly)other);
    }

    public void set(UnitVector3DReadOnly other) {
        this.vector.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setX(double x) {
        this.vector.setX(x);
    }

    public void setY(double y) {
        this.vector.setY(y);
    }

    public void setZ(double z) {
        this.vector.setZ(z);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getRawX() {
        return this.vector.getRawX();
    }

    public double getRawY() {
        return this.vector.getRawY();
    }

    public double getRawZ() {
        return this.vector.getRawZ();
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTuple3DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.vector, (Object)this.referenceFrame);
    }
}

