/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class FrameBoundingBox2D
implements FrameBoundingBox2DBasics,
Settable<FrameBoundingBox2D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint2DBasics minPoint = EuclidFrameFactories.newFixedFramePoint2DBasics(this);
    private final FixedFramePoint2DBasics maxPoint = EuclidFrameFactories.newFixedFramePoint2DBasics(this);

    public FrameBoundingBox2D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameBoundingBox2D(ReferenceFrame referenceFrame) {
        this.setToNaN(referenceFrame);
    }

    public FrameBoundingBox2D(ReferenceFrame referenceFrame, Point2DReadOnly min, Point2DReadOnly max) {
        this.setIncludingFrame(referenceFrame, min, max);
    }

    public FrameBoundingBox2D(FramePoint2DReadOnly min, FramePoint2DReadOnly max) {
        this.setIncludingFrame(min, max);
    }

    public FrameBoundingBox2D(ReferenceFrame referenceFrame, BoundingBox2DReadOnly boundingBox2DReadOnly) {
        this.setIncludingFrame(referenceFrame, boundingBox2DReadOnly);
    }

    public FrameBoundingBox2D(FrameBoundingBox2DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(FrameBoundingBox2D other) {
        FrameBoundingBox2DBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FixedFramePoint2DBasics getMinPoint() {
        return this.minPoint;
    }

    @Override
    public FixedFramePoint2DBasics getMaxPoint() {
        return this.maxPoint;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameBoundingBox2DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

