/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreIOTools;

public class MethodSignature {
    private String name;
    private List<Class<?>> parameterTypes;
    private Class<?> returnType;

    public MethodSignature() {
    }

    public MethodSignature(String name, Class<?> ... parameterTypes) {
        this.setName(name);
        this.setParameterTypes(parameterTypes);
    }

    public MethodSignature(MethodSignature other) {
        this.set(other);
    }

    public MethodSignature(Method method) {
        this.set(method);
    }

    public void set(MethodSignature other) {
        this.name = other.getName();
        this.setParameterTypes(other.toParameterTypeArray());
        this.returnType = other.getReturnType();
    }

    public void set(Method method) {
        this.name = method.getName();
        this.setParameterTypes(method.getParameterTypes());
        this.returnType = method.getReturnType();
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getParameterCount() {
        return this.parameterTypes.size();
    }

    public void setParameterTypes(Class<?> ... parameterTypes) {
        this.parameterTypes = new ArrayList(Arrays.asList(parameterTypes));
    }

    public void addParameterType(int index, Class<?> parameterType) {
        this.parameterTypes.add(index, parameterType);
    }

    public Class<?> removeParameterType(int index) {
        return this.parameterTypes.remove(index);
    }

    public Class<?> setParameterType(int index, Class<?> parameterType) {
        return this.parameterTypes.set(index, parameterType);
    }

    public Class<?> setReturnType(Class<?> returnType) {
        Class<?> oldReturnType = this.returnType;
        this.returnType = returnType;
        return oldReturnType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] toParameterTypeArray() {
        return this.parameterTypes.toArray(new Class[0]);
    }

    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    public Class<?> getParameterType(int index) {
        return this.parameterTypes.get(index);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public String getMethodSimpleName() {
        return MethodSignature.getMethodSimpleName(this.returnType, this.name, this.parameterTypes);
    }

    public static String getMethodSimpleName(Method method) {
        return MethodSignature.getMethodSimpleName(method.getReturnType(), method.getName(), method.getParameterTypes());
    }

    public static String getMethodSimpleName(Class<?> returnType, String methodName, Class<?> ... parameterTypes) {
        return MethodSignature.getMethodSimpleName(returnType, methodName, Arrays.asList(parameterTypes));
    }

    public static String getMethodSimpleName(Class<?> returnType, String methodName, Collection<Class<?>> parameterTypes) {
        String returnTypeName = returnType == null ? "void" : returnType.getSimpleName();
        return returnTypeName + " " + methodName + EuclidCoreIOTools.getCollectionString((String)"(", (String)")", (String)", ", parameterTypes, Class::getSimpleName);
    }

    public String toString() {
        return this.getMethodSimpleName();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MethodSignature) {
            MethodSignature other = (MethodSignature)object;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes)) {
                return false;
            }
            return this.returnType == other.returnType;
        }
        return false;
    }
}

