/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameRotationMatrix
implements FrameRotationMatrixBasics,
Settable<FrameRotationMatrix> {
    private ReferenceFrame referenceFrame;
    private final RotationMatrix rotationMatrix = new RotationMatrix();

    public FrameRotationMatrix() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.setIncludingFrame(referenceFrame, m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, double[] rotationMatrixArray) {
        this.setIncludingFrame(referenceFrame, rotationMatrixArray);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, DMatrix rotationMatrix) {
        this.setIncludingFrame(referenceFrame, rotationMatrix);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, Matrix3DReadOnly rotationMatrix) {
        this.setIncludingFrame(referenceFrame, rotationMatrix);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, RotationMatrixReadOnly rotationMatrixReadOnly) {
        this.setIncludingFrame(referenceFrame, rotationMatrixReadOnly);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation) {
        this.setIncludingFrame(referenceFrame, orientation);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, Vector3DReadOnly rotationVector) {
        this.setRotationVectorIncludingFrame(referenceFrame, rotationVector);
    }

    public FrameRotationMatrix(ReferenceFrame referenceFrame, double yaw, double pitch, double roll) {
        this.setYawPitchRollIncludingFrame(referenceFrame, yaw, pitch, roll);
    }

    public FrameRotationMatrix(FrameMatrix3DReadOnly rotationMatrix) {
        this.setIncludingFrame(rotationMatrix);
    }

    public FrameRotationMatrix(FrameRotationMatrixReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameRotationMatrix(FrameOrientation3DReadOnly orientation) {
        this.setIncludingFrame(orientation);
    }

    public FrameRotationMatrix(FrameVector3DReadOnly rotationVector) {
        this.setRotationVectorIncludingFrame(rotationVector);
    }

    public void set(FrameRotationMatrix other) {
        FrameRotationMatrixBasics.super.set((FrameRotationMatrixReadOnly)other);
    }

    public void set(RotationMatrixReadOnly other) {
        this.rotationMatrix.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setUnsafe(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.rotationMatrix.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public void setIdentity() {
        this.rotationMatrix.setIdentity();
    }

    public void setToNaN() {
        this.rotationMatrix.setToNaN();
    }

    public void normalize() {
        this.rotationMatrix.normalize();
    }

    public boolean isIdentity() {
        return this.rotationMatrix.isIdentity();
    }

    public void markAsDirty() {
        this.rotationMatrix.markAsDirty();
    }

    public void transpose() {
        this.rotationMatrix.transpose();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean isDirty() {
        return this.rotationMatrix.isDirty();
    }

    public double getM00() {
        return this.rotationMatrix.getM00();
    }

    public double getM01() {
        return this.rotationMatrix.getM01();
    }

    public double getM02() {
        return this.rotationMatrix.getM02();
    }

    public double getM10() {
        return this.rotationMatrix.getM10();
    }

    public double getM11() {
        return this.rotationMatrix.getM11();
    }

    public double getM12() {
        return this.rotationMatrix.getM12();
    }

    public double getM20() {
        return this.rotationMatrix.getM20();
    }

    public double getM21() {
        return this.rotationMatrix.getM21();
    }

    public double getM22() {
        return this.rotationMatrix.getM22();
    }

    public boolean equals(Object object) {
        if (object instanceof FrameMatrix3DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.rotationMatrix, (Object)this.referenceFrame);
    }
}

