/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class FrameQuaternion
implements FrameQuaternionBasics,
Settable<FrameQuaternion> {
    private ReferenceFrame referenceFrame;
    private final Quaternion quaternion = new Quaternion();

    public FrameQuaternion() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameQuaternion(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, double x, double y, double z, double s) {
        this.setIncludingFrame(referenceFrame, (QuaternionReadOnly)new Quaternion(x, y, z, s));
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, double[] quaternionArray) {
        this.setIncludingFrame(referenceFrame, quaternionArray);
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, DMatrix matrix) {
        this.setIncludingFrame(referenceFrame, matrix);
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, QuaternionReadOnly quaternionReadOnly) {
        this.setIncludingFrame(referenceFrame, quaternionReadOnly);
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, Tuple4DReadOnly tuple4DReadOnly) {
        this.setIncludingFrame(referenceFrame, tuple4DReadOnly);
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, Orientation3DReadOnly orientation3DReadOnly) {
        this.setIncludingFrame(referenceFrame, orientation3DReadOnly);
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, Vector3DReadOnly rotationVector) {
        this.setRotationVectorIncludingFrame(referenceFrame, rotationVector);
    }

    public FrameQuaternion(ReferenceFrame referenceFrame, double yaw, double pitch, double roll) {
        this.setYawPitchRollIncludingFrame(referenceFrame, yaw, pitch, roll);
    }

    public FrameQuaternion(FrameTuple4DReadOnly frameTuple4DReadOnly) {
        this.setIncludingFrame(frameTuple4DReadOnly);
    }

    public FrameQuaternion(FrameQuaternionReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameQuaternion(FrameOrientation3DReadOnly orientation) {
        this.setIncludingFrame(orientation);
    }

    public void set(FrameQuaternion other) {
        FrameQuaternionBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public final void setUnsafe(double qx, double qy, double qz, double qs) {
        this.quaternion.setUnsafe(qx, qy, qz, qs);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getX() {
        return this.quaternion.getX();
    }

    public double getY() {
        return this.quaternion.getY();
    }

    public double getZ() {
        return this.quaternion.getZ();
    }

    public double getS() {
        return this.quaternion.getS();
    }

    public boolean equals(Object object) {
        if (object instanceof FrameTuple4DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.quaternion, (Object)this.referenceFrame);
    }
}

