/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface FixedFrameBoundingBox2DBasics
extends BoundingBox2DBasics,
FrameBoundingBox2DReadOnly {
    @Override
    public FixedFramePoint2DBasics getMinPoint();

    @Override
    public FixedFramePoint2DBasics getMaxPoint();

    default public void setMin(ReferenceFrame referenceFrame, Point2DReadOnly min) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setMin(min);
    }

    default public void setMin(FramePoint2DReadOnly min) {
        this.setMin(min.getReferenceFrame(), min);
    }

    default public void setMax(ReferenceFrame referenceFrame, Point2DReadOnly max) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setMax(max);
    }

    default public void setMax(FramePoint2DReadOnly max) {
        this.setMax(max.getReferenceFrame(), max);
    }

    default public void set(ReferenceFrame referenceFrame, Point2DReadOnly min, Point2DReadOnly max) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(min, max);
    }

    default public void set(FramePoint2DReadOnly min, FramePoint2DReadOnly max) {
        min.checkReferenceFrameMatch(max);
        this.set(min.getReferenceFrame(), (Point2DReadOnly)min, max);
    }

    default public void set(ReferenceFrame referenceFrame, Point2DReadOnly center, Vector2DReadOnly halfSize) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(center, halfSize);
    }

    default public void set(FramePoint2DReadOnly center, Vector2DReadOnly halfSize) {
        this.set(center.getReferenceFrame(), (Point2DReadOnly)center, halfSize);
    }

    default public void set(FramePoint2DReadOnly center, FrameVector2DReadOnly halfSize) {
        center.checkReferenceFrameMatch(halfSize);
        this.set(center.getReferenceFrame(), (Point2DReadOnly)center, halfSize);
    }

    default public void set(ReferenceFrame referenceFrame, BoundingBox2DReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    default public void set(FrameBoundingBox2DReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void combine(ReferenceFrame referenceFrame, BoundingBox2DReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.combine(other);
    }

    default public void combine(FrameBoundingBox2DReadOnly other) {
        this.combine(other.getReferenceFrame(), (BoundingBox2DReadOnly)other);
    }

    default public void combine(ReferenceFrame referenceFrame, BoundingBox2DReadOnly boundingBoxOne, BoundingBox2DReadOnly boundingBoxTwo) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.combine(boundingBoxOne, boundingBoxTwo);
    }

    default public void combine(FrameBoundingBox2DReadOnly boundingBoxOne, BoundingBox2DReadOnly boundingBoxTwo) {
        this.combine(boundingBoxOne.getReferenceFrame(), boundingBoxOne, boundingBoxTwo);
    }

    default public void combine(BoundingBox2DReadOnly boundingBoxOne, FrameBoundingBox2DReadOnly boundingBoxTwo) {
        this.combine(boundingBoxTwo.getReferenceFrame(), boundingBoxOne, boundingBoxTwo);
    }

    default public void combine(FrameBoundingBox2DReadOnly boundingBoxOne, FrameBoundingBox2DReadOnly boundingBoxTwo) {
        boundingBoxOne.checkReferenceFrameMatch(boundingBoxTwo);
        this.combine(boundingBoxOne.getReferenceFrame(), boundingBoxOne, boundingBoxTwo);
    }

    default public void updateToIncludePoints(ReferenceFrame referenceFrame, Vertex2DSupplier vertex2DSupplier) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.updateToIncludePoints(vertex2DSupplier);
    }

    default public void updateToIncludePoints(FrameVertex2DSupplier vertex2DSupplier) {
        this.updateToIncludePoints(vertex2DSupplier.getReferenceFrame(), vertex2DSupplier);
    }

    default public void updateToIncludePoint(ReferenceFrame referenceFrame, Point2DReadOnly point) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.updateToIncludePoint(point);
    }

    default public void updateToIncludePoint(FramePoint2DReadOnly point) {
        this.updateToIncludePoint(point.getReferenceFrame(), point);
    }
}

