/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class FrameConvexPolygon2D
implements FrameConvexPolygon2DBasics,
Settable<FrameConvexPolygon2D> {
    private final boolean clockwiseOrdered = true;
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();
    private int numberOfVertices = 0;
    private final List<FixedFramePoint2DBasics> vertexBuffer = new ArrayList<FixedFramePoint2DBasics>();
    private final List<FixedFramePoint2DBasics> vertexBufferView = Collections.unmodifiableList(this.vertexBuffer);
    private final BoundingBox2D boundingBox = new BoundingBox2D();
    private final FixedFramePoint2DBasics centroid = EuclidFrameFactories.newFixedFramePoint2DBasics(this);
    private double area;
    private boolean isUpToDate = false;
    private ReferenceFrame referenceFrame;
    private final Point3D vertex3D = new Point3D();

    public FrameConvexPolygon2D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameConvexPolygon2D(ReferenceFrame referenceFrame) {
        this.setReferenceFrame(referenceFrame);
        this.clearAndUpdate();
    }

    public FrameConvexPolygon2D(ReferenceFrame referenceFrame, Vertex2DSupplier vertex2DSupplier) {
        this.setIncludingFrame(referenceFrame, vertex2DSupplier);
    }

    public FrameConvexPolygon2D(ReferenceFrame referenceFrame, Vertex3DSupplier vertex3DSupplier) {
        this.setIncludingFrame(referenceFrame, vertex3DSupplier);
    }

    public FrameConvexPolygon2D(FrameVertex2DSupplier frameVertex2DSupplier) {
        this.setIncludingFrame(frameVertex2DSupplier);
    }

    public FrameConvexPolygon2D(FrameVertex3DSupplier frameVertex3DSupplier) {
        this.setIncludingFrame(frameVertex3DSupplier);
    }

    public FrameConvexPolygon2D(FrameVertex2DSupplier firstVertex2DSupplier, FrameVertex2DSupplier secondVertex2DSupplier) {
        this.setIncludingFrame(firstVertex2DSupplier, secondVertex2DSupplier);
    }

    public void set(FrameConvexPolygon2D other) {
        FrameConvexPolygon2DBasics.super.set(other);
    }

    @Override
    public FixedFramePoint2DBasics getVertexUnsafe(int index) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(index);
        return this.vertexBuffer.get(index);
    }

    public void notifyVerticesChanged() {
        this.isUpToDate = false;
    }

    public void clear() {
        this.numberOfVertices = 0;
        this.area = Double.NaN;
        this.centroid.setToNaN();
        this.boundingBox.setToNaN();
        this.isUpToDate = false;
    }

    public void clearAndUpdate() {
        this.clear();
        this.isUpToDate = true;
    }

    @Override
    public void addVertexMatchingFrame(ReferenceFrame referenceFrame, Point2DReadOnly vertex, boolean checkIfTransformInXYPlane) {
        if (this.getReferenceFrame() == referenceFrame) {
            this.addVertex(vertex);
        } else {
            referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, this.getReferenceFrame());
            this.addVertex(vertex);
            this.getVertexUnsafe(this.getNumberOfVertices() - 1).applyTransform((Transform)this.transformToDesiredFrame, checkIfTransformInXYPlane);
        }
    }

    @Override
    public void addVertexMatchingFrame(ReferenceFrame referenceFrame, Point3DReadOnly vertex) {
        if (this.getReferenceFrame() == referenceFrame) {
            this.addVertex(vertex);
        } else {
            referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, this.getReferenceFrame());
            this.transformToDesiredFrame.transform(vertex, (Point3DBasics)this.vertex3D);
            this.addVertex((Point3DReadOnly)this.vertex3D);
        }
    }

    public void update() {
        if (this.isUpToDate) {
            return;
        }
        this.numberOfVertices = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(this.vertexBuffer, (int)this.numberOfVertices);
        this.isUpToDate = true;
        this.updateCentroidAndArea();
        this.updateBoundingBox();
    }

    public void updateCentroidAndArea() {
        this.area = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(this.vertexBuffer, (int)this.numberOfVertices, (boolean)true, (Point2DBasics)this.centroid);
    }

    public void addVertex(double x, double y) {
        this.isUpToDate = false;
        this.setOrCreate(x, y, this.numberOfVertices);
        ++this.numberOfVertices;
    }

    private void setOrCreate(double x, double y, int i) {
        while (i >= this.vertexBuffer.size()) {
            this.vertexBuffer.add(EuclidFrameFactories.newFixedFramePoint2DBasics(this));
        }
        this.vertexBuffer.get(i).set(x, y);
    }

    public void removeVertex(int indexOfVertexToRemove) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(indexOfVertexToRemove);
        if (indexOfVertexToRemove == this.numberOfVertices - 1) {
            --this.numberOfVertices;
            return;
        }
        this.isUpToDate = false;
        Collections.swap(this.vertexBuffer, indexOfVertexToRemove, this.numberOfVertices - 1);
        --this.numberOfVertices;
    }

    @Override
    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public final void changeFrameAndProjectToXYPlane(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame, false);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public List<? extends FramePoint2DReadOnly> getVertexBufferView() {
        return this.vertexBufferView;
    }

    @Override
    public FramePoint2DReadOnly getCentroid() {
        return this.centroid;
    }

    public boolean isClockwiseOrdered() {
        return true;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    public double getArea() {
        return this.area;
    }

    public BoundingBox2DBasics getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameConvexPolygon2DReadOnly) {
            return this.equals((EuclidFrameGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)Boolean.hashCode(true), this.vertexBufferView);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.referenceFrame);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

