/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;

public class FrameLineSegment2D
implements FrameLineSegment2DBasics {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint2DBasics firstEndpoint = EuclidFrameFactories.newFixedFramePoint2DBasics(this);
    private final FixedFramePoint2DBasics secondEndpoint = EuclidFrameFactories.newFixedFramePoint2DBasics(this);
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public FrameLineSegment2D() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameLineSegment2D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameLineSegment2D(LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), lineSegment2DReadOnly);
    }

    public FrameLineSegment2D(ReferenceFrame referenceFrame, LineSegment2DReadOnly lineSegment2DReadOnly) {
        this.setIncludingFrame(referenceFrame, lineSegment2DReadOnly);
    }

    public FrameLineSegment2D(FrameLineSegment2DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameLineSegment2D(FramePoint2DReadOnly firstEndpoint, FramePoint2DReadOnly secondEndpoint) {
        this.setIncludingFrame(firstEndpoint, secondEndpoint);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public FixedFramePoint2DBasics getFirstEndpoint() {
        return this.firstEndpoint;
    }

    @Override
    public FixedFramePoint2DBasics getSecondEndpoint() {
        return this.secondEndpoint;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame);
        this.referenceFrame = desiredFrame;
    }

    @Override
    public void changeFrameAndProjectToXYPlane(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.referenceFrame) {
            return;
        }
        this.referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((Transform)this.transformToDesiredFrame, false);
        this.referenceFrame = desiredFrame;
    }

    public boolean equals(Object object) {
        if (object instanceof FrameLineSegment2DReadOnly) {
            return this.equals((FrameLineSegment2DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.firstEndpoint, (Object)this.secondEndpoint);
    }
}

