/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameMatrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameYawPitchRollReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class EuclidFrameTestTools {
    private static final String DEFAULT_FORMAT = EuclidCoreTestTools.DEFAULT_FORMAT;

    private EuclidFrameTestTools() {
    }

    public static void assertRotationFrameVectorGeometricallyEquals(FrameVector3DReadOnly expected, FrameVector3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertRotationFrameVectorGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertRotationFrameVectorGeometricallyEquals(String messagePrefix, FrameVector3DReadOnly expected, FrameVector3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertRotationFrameVectorGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertRotationFrameVectorGeometricallyEquals(String messagePrefix, FrameVector3DReadOnly expected, FrameVector3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((String)messagePrefix, (Vector3DReadOnly)expected, (Vector3DReadOnly)actual, (double)epsilon);
    }

    public static void assertFrameYawPitchRollEquals(FrameYawPitchRollReadOnly expected, FrameYawPitchRollReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameYawPitchRollEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameYawPitchRollEquals(String messagePrefix, FrameYawPitchRollReadOnly expected, FrameYawPitchRollReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameYawPitchRollEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameYawPitchRollEquals(String messagePrefix, FrameYawPitchRollReadOnly expected, FrameYawPitchRollReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertYawPitchRollEquals((String)messagePrefix, (YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameYawPitchRollGeometricallyEquals(FrameYawPitchRollReadOnly expected, FrameYawPitchRollReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameYawPitchRollGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameYawPitchRollGeometricallyEquals(String messagePrefix, FrameYawPitchRollReadOnly expected, FrameYawPitchRollReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameYawPitchRollGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameYawPitchRollGeometricallyEquals(String messagePrefix, FrameYawPitchRollReadOnly expected, FrameYawPitchRollReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((String)messagePrefix, (YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameTuple2DEquals(FrameTuple2DReadOnly expected, FrameTuple2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameTuple2DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameTuple2DEquals(String messagePrefix, FrameTuple2DReadOnly expected, FrameTuple2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameTuple2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameTuple2DEquals(String messagePrefix, FrameTuple2DReadOnly expected, FrameTuple2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertTuple2DEquals((String)messagePrefix, (Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFramePoint2DGeometricallyEquals(FramePoint2DReadOnly expected, FramePoint2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFramePoint2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFramePoint2DGeometricallyEquals(String messagePrefix, FramePoint2DReadOnly expected, FramePoint2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFramePoint2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFramePoint2DGeometricallyEquals(String messagePrefix, FramePoint2DReadOnly expected, FramePoint2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)messagePrefix, (Point2DReadOnly)expected, (Point2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameVector2DGeometricallyEquals(FrameVector2DReadOnly expected, FrameVector2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameVector2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameVector2DGeometricallyEquals(String messagePrefix, FrameVector2DReadOnly expected, FrameVector2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameVector2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameVector2DGeometricallyEquals(String messagePrefix, FrameVector2DReadOnly expected, FrameVector2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertVector2DGeometricallyEquals((String)messagePrefix, (Vector2DReadOnly)expected, (Vector2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameTuple3DEquals(FrameTuple3DReadOnly expected, FrameTuple3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameTuple3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameTuple3DEquals(String messagePrefix, FrameTuple3DReadOnly expected, FrameTuple3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameTuple3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameTuple3DEquals(String messagePrefix, FrameTuple3DReadOnly expected, FrameTuple3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertTuple3DEquals((String)messagePrefix, (Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFramePoint3DGeometricallyEquals(FramePoint3DReadOnly expected, FramePoint3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFramePoint3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFramePoint3DGeometricallyEquals(String messagePrefix, FramePoint3DReadOnly expected, FramePoint3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFramePoint3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFramePoint3DGeometricallyEquals(String messagePrefix, FramePoint3DReadOnly expected, FramePoint3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)messagePrefix, (Point3DReadOnly)expected, (Point3DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameVector3DGeometricallyEquals(FrameVector3DReadOnly expected, FrameVector3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameVector3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameVector3DGeometricallyEquals(String messagePrefix, FrameVector3DReadOnly expected, FrameVector3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameVector3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameVector3DGeometricallyEquals(String messagePrefix, FrameVector3DReadOnly expected, FrameVector3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((String)messagePrefix, (Vector3DReadOnly)expected, (Vector3DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameTuple4DEquals(FrameTuple4DReadOnly expected, FrameTuple4DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameTuple4DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameTuple4DEquals(String messagePrefix, FrameTuple4DReadOnly expected, FrameTuple4DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameTuple4DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameTuple4DEquals(String messagePrefix, FrameTuple4DReadOnly expected, FrameTuple4DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertTuple4DEquals((String)messagePrefix, (Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameVector4DGeometricallyEquals(FrameVector4DReadOnly expected, FrameVector4DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameVector4DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameVector4DGeometricallyEquals(String messagePrefix, FrameVector4DReadOnly expected, FrameVector4DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameVector4DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameVector4DGeometricallyEquals(String messagePrefix, FrameVector4DReadOnly expected, FrameVector4DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertVector4DGeometricallyEquals((String)messagePrefix, (Vector4DReadOnly)expected, (Vector4DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameQuaternionGeometricallyEquals(FrameQuaternionReadOnly expected, FrameQuaternionReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameQuaternionGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameQuaternionGeometricallyEquals(String messagePrefix, FrameQuaternionReadOnly expected, FrameQuaternionReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameQuaternionGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameQuaternionGeometricallyEquals(String messagePrefix, FrameQuaternionReadOnly expected, FrameQuaternionReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertQuaternionGeometricallyEquals((String)messagePrefix, (QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameOrientation2DEquals(FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameOrientation2DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameOrientation2DEquals(String messagePrefix, FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameOrientation2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameOrientation2DEquals(String messagePrefix, FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertOrientation2DEquals((String)messagePrefix, (Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameOrientation2DGeometricallyEquals(FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameOrientation2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameOrientation2DGeometricallyEquals(String messagePrefix, FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameOrientation2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameOrientation2DGeometricallyEquals(String messagePrefix, FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertOrientation2DGeometricallyEquals((String)messagePrefix, (Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameMatrix3DEquals(FrameMatrix3DReadOnly expected, FrameMatrix3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameMatrix3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameMatrix3DEquals(String messagePrefix, FrameMatrix3DReadOnly expected, FrameMatrix3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameMatrix3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameMatrix3DEquals(String messagePrefix, FrameMatrix3DReadOnly expected, FrameMatrix3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertMatrix3DEquals((String)messagePrefix, (Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameRotationMatrixGeometricallyEquals(FrameRotationMatrixReadOnly expected, FrameRotationMatrixReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameRotationMatrixGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameRotationMatrixGeometricallyEquals(String messagePrefix, FrameRotationMatrixReadOnly expected, FrameRotationMatrixReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameRotationMatrixGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameRotationMatrixGeometricallyEquals(String messagePrefix, FrameRotationMatrixReadOnly expected, FrameRotationMatrixReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((String)messagePrefix, (RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameBoundingBox2DEquals(FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox2DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameBoundingBox2DEquals(String messagePrefix, FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameBoundingBox2DEquals(String messagePrefix, FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidGeometryTestTools.assertBoundingBox2DEquals((String)messagePrefix, (BoundingBox2DReadOnly)expected, (BoundingBox2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameBoundingBox2DGeometricallyEquals(FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameBoundingBox2DGeometricallyEquals(String messagePrefix, FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameBoundingBox2DGeometricallyEquals(String messagePrefix, FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidGeometryTestTools.assertBoundingBox2DGeometricallyEquals((String)messagePrefix, (BoundingBox2DReadOnly)expected, (BoundingBox2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameBoundingBox3DEquals(FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox3DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameBoundingBox3DEquals(String messagePrefix, FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox3DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameBoundingBox3DEquals(String messagePrefix, FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidGeometryTestTools.assertBoundingBox3DEquals((String)messagePrefix, (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameBoundingBox3DGeometricallyEquals(FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox3DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameBoundingBox3DGeometricallyEquals(String messagePrefix, FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameBoundingBox3DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameBoundingBox3DGeometricallyEquals(String messagePrefix, FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidGeometryTestTools.assertBoundingBox3DGeometricallyEquals((String)messagePrefix, (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameConvexPolygon2DEquals(FrameConvexPolygon2DReadOnly expected, FrameConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameConvexPolygon2DEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameConvexPolygon2DEquals(String messagePrefix, FrameConvexPolygon2DReadOnly expected, FrameConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameConvexPolygon2DEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameConvexPolygon2DEquals(String messagePrefix, FrameConvexPolygon2DReadOnly expected, FrameConvexPolygon2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidGeometryTestTools.assertConvexPolygon2DEquals((String)messagePrefix, (ConvexPolygon2DReadOnly)expected, (ConvexPolygon2DReadOnly)actual, (double)epsilon, (String)format);
    }

    public static void assertFrameConvexPolygon2DGeometricallyEquals(FrameConvexPolygon2DReadOnly expected, FrameConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameConvexPolygon2DGeometricallyEquals(null, expected, actual, epsilon);
    }

    public static void assertFrameConvexPolygon2DGeometricallyEquals(String messagePrefix, FrameConvexPolygon2DReadOnly expected, FrameConvexPolygon2DReadOnly actual, double epsilon) {
        EuclidFrameTestTools.assertFrameConvexPolygon2DGeometricallyEquals(messagePrefix, expected, actual, epsilon, DEFAULT_FORMAT);
    }

    public static void assertFrameConvexPolygon2DGeometricallyEquals(String messagePrefix, FrameConvexPolygon2DReadOnly expected, FrameConvexPolygon2DReadOnly actual, double epsilon, String format) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null ^ actual != null) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        if (expected.getReferenceFrame() != actual.getReferenceFrame()) {
            EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual, format);
        }
        EuclidGeometryTestTools.assertConvexPolygon2DGeometricallyEquals((String)messagePrefix, (ConvexPolygon2DReadOnly)expected, (ConvexPolygon2DReadOnly)actual, (double)epsilon, (String)format);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameTuple2DReadOnly expected, FrameTuple2DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameTuple2DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameTuple2DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameTuple3DReadOnly expected, FrameTuple3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameTuple3DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameTuple3DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameTuple4DReadOnly expected, FrameTuple4DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameTuple4DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameTuple4DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameOrientation2DReadOnly expected, FrameOrientation2DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameOrientation2DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameOrientation2DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameYawPitchRollReadOnly expected, FrameYawPitchRollReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameYawPitchRollString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameYawPitchRollString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameMatrix3DReadOnly expected, FrameMatrix3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameMatrix3DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameMatrix3DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameBoundingBox2DReadOnly expected, FrameBoundingBox2DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameBoundingBox2DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameBoundingBox2DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameBoundingBox3DReadOnly expected, FrameBoundingBox3DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameBoundingBox3DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameBoundingBox3DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, FrameConvexPolygon2DReadOnly expected, FrameConvexPolygon2DReadOnly actual, String format) {
        String expectedAsString = EuclidFrameIOTools.getFrameConvexPolygon2DString(format, expected);
        String actualAsString = EuclidFrameIOTools.getFrameConvexPolygon2DString(format, actual);
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, String expectedAsString, String actualAsString) {
        EuclidFrameTestTools.throwNotEqualAssertionError(messagePrefix, expectedAsString, actualAsString, null);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, String expectedAsString, String actualAsString, String differenceAsString) {
        String errorMessage = EuclidFrameTestTools.addPrefixToMessage(messagePrefix, "expected:\n" + expectedAsString + "\n but was:\n" + actualAsString);
        if (differenceAsString != null) {
            errorMessage = errorMessage + "\nDifference of: " + differenceAsString;
        }
        throw new AssertionError((Object)errorMessage);
    }

    private static String addPrefixToMessage(String prefix, String message) {
        if (prefix != null && !prefix.isEmpty()) {
            return prefix + " " + message;
        }
        return message;
    }
}

