/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface FrameLine3DReadOnly
extends Line3DReadOnly,
ReferenceFrameHolder {
    public FramePoint3DReadOnly getPoint();

    public FrameUnitVector3DReadOnly getDirection();

    default public void get(FixedFramePoint3DBasics pointToPack, FixedFrameVector3DBasics directionToPack) {
        this.checkReferenceFrameMatch(pointToPack, directionToPack);
        super.get((Point3DBasics)pointToPack, (Vector3DBasics)directionToPack);
    }

    default public void get(FramePoint3DBasics pointToPack, FrameVector3DBasics directionToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        directionToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point3DBasics)pointToPack, (Vector3DBasics)directionToPack);
    }

    default public void get(Point3DBasics pointToPack, FixedFrameVector3DBasics directionToPack) {
        this.checkReferenceFrameMatch(directionToPack);
        super.get(pointToPack, (Vector3DBasics)directionToPack);
    }

    default public void get(Point3DBasics pointToPack, FrameVector3DBasics directionToPack) {
        directionToPack.setReferenceFrame(this.getReferenceFrame());
        super.get(pointToPack, (Vector3DBasics)directionToPack);
    }

    default public void get(FixedFramePoint3DBasics pointToPack, Vector3DBasics directionToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.get((Point3DBasics)pointToPack, directionToPack);
    }

    default public void get(FramePoint3DBasics pointToPack, Vector3DBasics directionToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.get((Point3DBasics)pointToPack, directionToPack);
    }

    default public boolean isCollinear(FrameLine3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.isCollinear((Line3DReadOnly)other, epsilon);
    }

    default public boolean isCollinear(FrameLine3DReadOnly other, double angleEpsilon, double distanceEpsilon) {
        this.checkReferenceFrameMatch(other);
        return super.isCollinear((Line3DReadOnly)other, angleEpsilon, distanceEpsilon);
    }

    default public double closestPointsWith(FrameLine3DReadOnly otherLine, Point3DBasics closestPointOnThisLineToPack, Point3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(otherLine);
        return super.closestPointsWith((Line3DReadOnly)otherLine, closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(Line3DReadOnly otherLine, FixedFramePoint3DBasics closestPointOnThisLineToPack, Point3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(closestPointOnThisLineToPack);
        return super.closestPointsWith(otherLine, (Point3DBasics)closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(Line3DReadOnly otherLine, FramePoint3DBasics closestPointOnThisLineToPack, Point3DBasics closestPointOnOtherLineToPack) {
        closestPointOnThisLineToPack.setReferenceFrame(this.getReferenceFrame());
        return super.closestPointsWith(otherLine, (Point3DBasics)closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(Line3DReadOnly otherLine, Point3DBasics closestPointOnThisLineToPack, FixedFramePoint3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(closestPointOnOtherLineToPack);
        return super.closestPointsWith(otherLine, closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(Line3DReadOnly otherLine, Point3DBasics closestPointOnThisLineToPack, FramePoint3DBasics closestPointOnOtherLineToPack) {
        closestPointOnOtherLineToPack.setReferenceFrame(this.getReferenceFrame());
        return super.closestPointsWith(otherLine, closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(FrameLine3DReadOnly otherLine, FixedFramePoint3DBasics closestPointOnThisLineToPack, Point3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(otherLine, closestPointOnThisLineToPack);
        return super.closestPointsWith((Line3DReadOnly)otherLine, (Point3DBasics)closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(FrameLine3DReadOnly otherLine, FramePoint3DBasics closestPointOnThisLineToPack, Point3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(otherLine);
        closestPointOnThisLineToPack.setReferenceFrame(this.getReferenceFrame());
        return super.closestPointsWith((Line3DReadOnly)otherLine, (Point3DBasics)closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(FrameLine3DReadOnly otherLine, Point3DBasics closestPointOnThisLineToPack, FixedFramePoint3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(otherLine, closestPointOnOtherLineToPack);
        return super.closestPointsWith((Line3DReadOnly)otherLine, closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(FrameLine3DReadOnly otherLine, Point3DBasics closestPointOnThisLineToPack, FramePoint3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(otherLine);
        closestPointOnOtherLineToPack.setReferenceFrame(this.getReferenceFrame());
        return super.closestPointsWith((Line3DReadOnly)otherLine, closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(FrameLine3DReadOnly otherLine, FixedFramePoint3DBasics closestPointOnThisLineToPack, FixedFramePoint3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(otherLine, closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
        return super.closestPointsWith((Line3DReadOnly)otherLine, (Point3DBasics)closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(FrameLine3DReadOnly otherLine, FramePoint3DBasics closestPointOnThisLineToPack, FramePoint3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(otherLine);
        closestPointOnThisLineToPack.setReferenceFrame(this.getReferenceFrame());
        closestPointOnOtherLineToPack.setReferenceFrame(this.getReferenceFrame());
        return super.closestPointsWith((Line3DReadOnly)otherLine, (Point3DBasics)closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(Line3DReadOnly otherLine, FixedFramePoint3DBasics closestPointOnThisLineToPack, FixedFramePoint3DBasics closestPointOnOtherLineToPack) {
        this.checkReferenceFrameMatch(closestPointOnThisLineToPack, closestPointOnOtherLineToPack);
        return super.closestPointsWith(otherLine, (Point3DBasics)closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double closestPointsWith(Line3DReadOnly otherLine, FramePoint3DBasics closestPointOnThisLineToPack, FramePoint3DBasics closestPointOnOtherLineToPack) {
        closestPointOnThisLineToPack.setReferenceFrame(this.getReferenceFrame());
        closestPointOnOtherLineToPack.setReferenceFrame(this.getReferenceFrame());
        return super.closestPointsWith(otherLine, (Point3DBasics)closestPointOnThisLineToPack, (Point3DBasics)closestPointOnOtherLineToPack);
    }

    default public double distance(FrameLine3DReadOnly otherLine) {
        this.checkReferenceFrameMatch(otherLine);
        return super.distance((Line3DReadOnly)otherLine);
    }

    default public double distance(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.distance((Point3DReadOnly)point);
    }

    default public void pointOnLineGivenParameter(double t, FixedFramePoint3DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.pointOnLineGivenParameter(t, (Point3DBasics)pointToPack);
    }

    default public void pointOnLineGivenParameter(double t, FramePoint3DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.pointOnLineGivenParameter(t, (Point3DBasics)pointToPack);
    }

    default public FramePoint3D orthogonalProjectionCopy(FramePoint3DReadOnly pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        return new FramePoint3D(this.getReferenceFrame(), (Tuple3DReadOnly)super.orthogonalProjectionCopy((Point3DReadOnly)pointToProject));
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, projectionToPack);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, FixedFramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(projectionToPack);
        return super.orthogonalProjection(pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection(pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FixedFramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject, projectionToPack);
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection((Point3DReadOnly)pointToProject, (Point3DBasics)projectionToPack);
    }

    default public double parameterGivenPointOnLine(FramePoint3DReadOnly pointOnLine, double epsilon) {
        this.checkReferenceFrameMatch(pointOnLine);
        return super.parameterGivenPointOnLine((Point3DReadOnly)pointOnLine, epsilon);
    }

    default public boolean isPointOnLine(FramePoint3DReadOnly point, double epsilon) {
        this.checkReferenceFrameMatch(point);
        return super.isPointOnLine((Point3DReadOnly)point, epsilon);
    }

    default public void getTwoPointsOnLine(FixedFramePoint3DBasics firstPointOnLineToPack, Point3DBasics secondPointOnLineToPack) {
        this.checkReferenceFrameMatch(firstPointOnLineToPack);
        super.getTwoPointsOnLine((Point3DBasics)firstPointOnLineToPack, secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(FramePoint3DBasics firstPointOnLineToPack, Point3DBasics secondPointOnLineToPack) {
        firstPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.getTwoPointsOnLine((Point3DBasics)firstPointOnLineToPack, secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(Point3DBasics firstPointOnLineToPack, FixedFramePoint3DBasics secondPointOnLineToPack) {
        this.checkReferenceFrameMatch(secondPointOnLineToPack);
        super.getTwoPointsOnLine(firstPointOnLineToPack, (Point3DBasics)secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(Point3DBasics firstPointOnLineToPack, FramePoint3DBasics secondPointOnLineToPack) {
        secondPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.getTwoPointsOnLine(firstPointOnLineToPack, (Point3DBasics)secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(FixedFramePoint3DBasics firstPointOnLineToPack, FixedFramePoint3DBasics secondPointOnLineToPack) {
        this.checkReferenceFrameMatch(firstPointOnLineToPack, secondPointOnLineToPack);
        super.getTwoPointsOnLine((Point3DBasics)firstPointOnLineToPack, (Point3DBasics)secondPointOnLineToPack);
    }

    default public void getTwoPointsOnLine(FramePoint3DBasics firstPointOnLineToPack, FramePoint3DBasics secondPointOnLineToPack) {
        firstPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        secondPointOnLineToPack.setReferenceFrame(this.getReferenceFrame());
        super.getTwoPointsOnLine((Point3DBasics)firstPointOnLineToPack, (Point3DBasics)secondPointOnLineToPack);
    }

    default public boolean epsilonEquals(FrameLine3DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((Line3DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FrameLine3DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((Line3DReadOnly)other, epsilon);
    }

    default public boolean equals(FrameLine3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.equals((Line3DReadOnly)other);
    }
}

