/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface FrameBoundingBox2DReadOnly
extends BoundingBox2DReadOnly,
ReferenceFrameHolder {
    public FramePoint2DReadOnly getMinPoint();

    public FramePoint2DReadOnly getMaxPoint();

    default public void getCenterPoint(FixedFramePoint2DBasics centerToPack) {
        this.checkReferenceFrameMatch(centerToPack);
        super.getCenterPoint((Point2DBasics)centerToPack);
    }

    default public void getCenterPoint(FramePoint2DBasics centerToPack) {
        centerToPack.setReferenceFrame(this.getReferenceFrame());
        super.getCenterPoint((Point2DBasics)centerToPack);
    }

    default public void getPointGivenParameters(double xParameter, double yParameter, FixedFramePoint2DBasics pointToPack) {
        this.checkReferenceFrameMatch(pointToPack);
        super.getPointGivenParameters(xParameter, yParameter, (Point2DBasics)pointToPack);
    }

    default public void getPointGivenParameters(double xParameter, double yParameter, FramePoint2DBasics pointToPack) {
        pointToPack.setReferenceFrame(this.getReferenceFrame());
        super.getPointGivenParameters(xParameter, yParameter, (Point2DBasics)pointToPack);
    }

    default public boolean isInsideExclusive(FramePoint2DReadOnly query) {
        this.checkReferenceFrameMatch(query);
        return super.isInsideExclusive((Point2DReadOnly)query);
    }

    default public boolean isInsideInclusive(FramePoint2DReadOnly query) {
        this.checkReferenceFrameMatch(query);
        return super.isInsideInclusive((Point2DReadOnly)query);
    }

    default public boolean isInsideEpsilon(FramePoint2DReadOnly query, double epsilon) {
        this.checkReferenceFrameMatch(query);
        return super.isInsideEpsilon((Point2DReadOnly)query, epsilon);
    }

    default public boolean intersectsExclusive(FrameBoundingBox2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsExclusive((BoundingBox2DReadOnly)other);
    }

    default public boolean intersectsInclusive(FrameBoundingBox2DReadOnly other) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsInclusive((BoundingBox2DReadOnly)other);
    }

    default public boolean intersectsEpsilon(FrameBoundingBox2DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.intersectsEpsilon((BoundingBox2DReadOnly)other, epsilon);
    }

    default public boolean doesIntersectWithLine2D(FrameLine2DReadOnly line2D) {
        this.checkReferenceFrameMatch(line2D);
        return super.doesIntersectWithLine2D((Line2DReadOnly)line2D);
    }

    default public boolean doesIntersectWithLine2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return super.doesIntersectWithLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
    }

    default public boolean doesIntersectWithLineSegment2D(FrameLineSegment2DReadOnly lineSegment2D) {
        this.checkReferenceFrameMatch(lineSegment2D);
        return super.doesIntersectWithLineSegment2D((LineSegment2DReadOnly)lineSegment2D);
    }

    default public boolean doesIntersectWithLineSegment2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return super.doesIntersectWithLineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
    }

    default public boolean doesIntersectWithRay2D(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        return super.doesIntersectWithRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
    }

    default public int intersectionWithLine2D(FrameLine2DReadOnly line2D, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return this.intersectionWithLine2D(line2D.getPoint(), (FrameVector2DReadOnly)line2D.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(Line2DReadOnly line2D, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLine2D(line2D.getPoint(), (Vector2DReadOnly)line2D.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(Line2DReadOnly line2D, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLine2D(line2D.getPoint(), (Vector2DReadOnly)line2D.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(FrameLine2DReadOnly line2D, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLine2D(line2D.getPoint(), (FrameVector2DReadOnly)line2D.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(FrameLine2DReadOnly line2D, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLine2D(line2D.getPoint(), (FrameVector2DReadOnly)line2D.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        return super.intersectionWithLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLine2D(pointOnLine, lineDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLine2D(pointOnLine, lineDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLine2D(FramePoint2DReadOnly pointOnLine, FrameVector2DReadOnly lineDirection, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(pointOnLine, lineDirection);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(FrameLineSegment2DReadOnly lineSegment2D, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return this.intersectionWithLineSegment2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(LineSegment2DReadOnly lineSegment2D, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLineSegment2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(LineSegment2DReadOnly lineSegment2D, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLineSegment2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(FrameLineSegment2DReadOnly lineSegment2D, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLineSegment2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(FrameLineSegment2DReadOnly lineSegment2D, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        return this.intersectionWithLineSegment2D(lineSegment2D.getFirstEndpoint(), lineSegment2D.getSecondEndpoint(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        return super.intersectionWithLineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLineSegment2D(lineSegmentStart, lineSegmentEnd, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLineSegment2D(lineSegmentStart, lineSegmentEnd, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithLineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithLineSegment2D(FramePoint2DReadOnly lineSegmentStart, FramePoint2DReadOnly lineSegmentEnd, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegmentStart, lineSegmentEnd);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithLineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay2D(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        return super.intersectionWithRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithRay2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithRay2D(rayOrigin, rayDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithRay2D(rayOrigin, rayDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay2D(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        }
        return super.intersectionWithRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay2D(FramePoint2DReadOnly rayOrigin, FrameVector2DReadOnly rayDirection, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(rayOrigin, rayDirection);
        if (firstIntersectionToPack != null) {
            this.checkReferenceFrameMatch(firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null) {
            this.checkReferenceFrameMatch(secondIntersectionToPack);
        }
        return super.intersectionWithRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public boolean epsilonEquals(FrameBoundingBox2DReadOnly other, double epsilon) {
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((BoundingBox2DReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(FrameBoundingBox2DReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        return super.geometricallyEquals((BoundingBox2DReadOnly)other, epsilon);
    }

    default public boolean equals(FrameBoundingBox2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return this.getMinPoint().equals(other.getMinPoint()) && this.getMaxPoint().equals(other.getMaxPoint());
    }
}

