/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameOrientation2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class FramePose2D
implements FramePose2DBasics,
GeometryObject<FramePose2D> {
    private ReferenceFrame referenceFrame;
    private final FixedFramePoint2DBasics position = EuclidFrameFactories.newFixedFramePoint2DBasics(this);
    private final FixedFrameOrientation2DBasics orientation = EuclidFrameFactories.newFixedFrameOrientation2DBasics(this);

    public FramePose2D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FramePose2D(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FramePose2D(Pose2DReadOnly pose2DReadOnly) {
        this.setIncludingFrame(ReferenceFrame.getWorldFrame(), pose2DReadOnly);
    }

    public FramePose2D(ReferenceFrame referenceFrame, Pose2DReadOnly pose) {
        this.setIncludingFrame(referenceFrame, pose);
    }

    public FramePose2D(ReferenceFrame referenceFrame, Tuple2DReadOnly position, double yaw) {
        this.setIncludingFrame(referenceFrame, position, yaw);
    }

    public FramePose2D(FrameTuple2DReadOnly position, FrameOrientation2DReadOnly orientation) {
        this.setIncludingFrame(position, orientation);
    }

    public FramePose2D(FramePose2DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FramePose2D(FramePose3DReadOnly framePose3DReadOnly) {
        this.setIncludingFrame(framePose3DReadOnly);
    }

    public void set(FramePose2D other) {
        FramePose2DBasics.super.set(other);
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFramePoint2DBasics getPosition() {
        return this.position;
    }

    @Override
    public FixedFrameOrientation2DBasics getOrientation() {
        return this.orientation;
    }

    public boolean equals(Object object) {
        if (object instanceof FramePose2DReadOnly) {
            return this.equals((FramePose2DReadOnly)object);
        }
        return false;
    }

    public boolean epsilonEquals(FramePose2D other, double epsilon) {
        return FramePose2DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(FramePose2D other, double epsilon) {
        return FramePose2DBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidFrameIOTools.getFramePose2DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.position, (Object)this.orientation);
    }
}

