/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class ReferenceFrameTools {
    private static final ReferenceFrame worldFrame = ReferenceFrameTools.constructARootFrame("World");

    private ReferenceFrameTools() {
    }

    public static ReferenceFrame constructARootFrame(String frameName) {
        ReferenceFrame ret = new ReferenceFrame(frameName){

            @Override
            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            }
        };
        return ret;
    }

    public static ReferenceFrame getWorldFrame() {
        return worldFrame;
    }

    public static ReferenceFrame constructFrameWithUnchangingTransformFromParent(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformFromParent) {
        RigidBodyTransform transformToParent = new RigidBodyTransform(transformFromParent);
        transformToParent.invert();
        return ReferenceFrameTools.constructFrameWithUnchangingTransformToParent(frameName, parentFrame, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static ReferenceFrame constructFrameWithUnchangingTranslationFromParent(String frameName, ReferenceFrame parentFrame, Tuple3DReadOnly translationOffsetFromParent) {
        RigidBodyTransform transformToParent = new RigidBodyTransform();
        transformToParent.getTranslation().set(translationOffsetFromParent);
        return ReferenceFrameTools.constructFrameWithUnchangingTransformToParent(frameName, parentFrame, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static ReferenceFrame constructFrameWithUnchangingTransformToParent(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        boolean isZupFrame = parentFrame.isZupFrame() && transformToParent.isRotation2D();
        boolean isAStationaryFrame = parentFrame.isAStationaryFrame();
        ReferenceFrame ret = new ReferenceFrame(frameName, parentFrame, transformToParent, isAStationaryFrame, isZupFrame){

            @Override
            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            }
        };
        return ret;
    }

    public static ReferenceFrame[] createPathFromRoot(ReferenceFrame referenceFrame) {
        ReferenceFrame parentFrame = referenceFrame.getParent();
        if (parentFrame == null) {
            return new ReferenceFrame[]{referenceFrame};
        }
        int newLength = parentFrame.getFramesStartingWithRootEndingWithThis().length + 1;
        ReferenceFrame[] ret = Arrays.copyOf(parentFrame.getFramesStartingWithRootEndingWithThis(), newLength);
        ret[newLength - 1] = referenceFrame;
        return ret;
    }

    public static void clearFrameTree(ReferenceFrame frame) {
        frame.getRootFrame().clearChildren();
    }

    public static void clearWorldFrameTree() {
        worldFrame.clearChildren();
    }

    public static Collection<ReferenceFrame> getAllFramesInTree(ReferenceFrame frame) {
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.add(frame.getRootFrame());
        ReferenceFrameTools.getAllChildren(frame.getRootFrame(), frames);
        return frames;
    }

    private static void getAllChildren(ReferenceFrame frame, Collection<ReferenceFrame> collectionToPack) {
        for (int i = 0; i < frame.getNumberOfChildren(); ++i) {
            ReferenceFrame child = frame.getChild(i);
            if (child == null) continue;
            collectionToPack.add(child);
            ReferenceFrameTools.getAllChildren(child, collectionToPack);
        }
    }
}

