/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex3DSupplier;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FixedFrameBoundingBox3DBasics
extends BoundingBox3DBasics,
FrameBoundingBox3DReadOnly {
    @Override
    public FixedFramePoint3DBasics getMinPoint();

    @Override
    public FixedFramePoint3DBasics getMaxPoint();

    default public void setMin(ReferenceFrame referenceFrame, Point3DReadOnly min) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setMin(min);
    }

    default public void setMin(FramePoint3DReadOnly min) {
        this.setMin(min.getReferenceFrame(), min);
    }

    default public void setMax(ReferenceFrame referenceFrame, Point3DReadOnly max) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.setMax(max);
    }

    default public void setMax(FramePoint3DReadOnly max) {
        this.setMax(max.getReferenceFrame(), max);
    }

    default public void set(ReferenceFrame referenceFrame, Point3DReadOnly min, Point3DReadOnly max) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(min, max);
    }

    default public void set(FramePoint3DReadOnly min, FramePoint3DReadOnly max) {
        min.checkReferenceFrameMatch(max);
        this.set(min.getReferenceFrame(), (Point3DReadOnly)min, max);
    }

    default public void set(ReferenceFrame referenceFrame, Point3DReadOnly center, Vector3DReadOnly halfSize) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(center, halfSize);
    }

    default public void set(FramePoint3DReadOnly center, Vector3DReadOnly halfSize) {
        this.set(center.getReferenceFrame(), (Point3DReadOnly)center, halfSize);
    }

    default public void set(FramePoint3DReadOnly center, FrameVector3DReadOnly halfSize) {
        center.checkReferenceFrameMatch(halfSize);
        this.set(center.getReferenceFrame(), (Point3DReadOnly)center, halfSize);
    }

    default public void set(ReferenceFrame referenceFrame, BoundingBox3DReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    default public void set(FrameBoundingBox3DReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void combine(ReferenceFrame referenceFrame, BoundingBox3DReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.combine(other);
    }

    default public void combine(FrameBoundingBox3DReadOnly other) {
        this.combine(other.getReferenceFrame(), (BoundingBox3DReadOnly)other);
    }

    default public void combine(ReferenceFrame referenceFrame, BoundingBox3DReadOnly boundingBoxOne, BoundingBox3DReadOnly boundingBoxTwo) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.combine(boundingBoxOne, boundingBoxTwo);
    }

    default public void combine(FrameBoundingBox3DReadOnly boundingBoxOne, BoundingBox3DReadOnly boundingBoxTwo) {
        this.combine(boundingBoxOne.getReferenceFrame(), boundingBoxOne, boundingBoxTwo);
    }

    default public void combine(BoundingBox3DReadOnly boundingBoxOne, FrameBoundingBox3DReadOnly boundingBoxTwo) {
        this.combine(boundingBoxTwo.getReferenceFrame(), boundingBoxOne, boundingBoxTwo);
    }

    default public void combine(FrameBoundingBox3DReadOnly boundingBoxOne, FrameBoundingBox3DReadOnly boundingBoxTwo) {
        boundingBoxOne.checkReferenceFrameMatch(boundingBoxTwo);
        this.combine(boundingBoxOne.getReferenceFrame(), boundingBoxOne, boundingBoxTwo);
    }

    default public void updateToIncludePoints(ReferenceFrame referenceFrame, Vertex3DSupplier vertex3DSupplier) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.updateToIncludePoints(vertex3DSupplier);
    }

    default public void updateToIncludePoints(FrameVertex3DSupplier vertex3DSupplier) {
        this.updateToIncludePoints(vertex3DSupplier.getReferenceFrame(), vertex3DSupplier);
    }

    default public void updateToIncludePoint(ReferenceFrame referenceFrame, Point3DReadOnly point) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.updateToIncludePoint(point);
    }

    default public void updateToIncludePoint(FramePoint3DReadOnly point) {
        this.updateToIncludePoint(point.getReferenceFrame(), point);
    }
}

