/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;

public abstract class ReferenceFrame {
    private static final String SEPARATOR = ":";
    private final String frameName;
    private final String nameId;
    private final long frameIndex;
    private long framesAddedToTree = 0L;
    private long additionalNameBasedHashCode;
    private final ReferenceFrame parentFrame;
    private final List<WeakReference<ReferenceFrame>> children = new ArrayList<WeakReference<ReferenceFrame>>();
    private boolean hasBeenRemoved = false;
    private final ReferenceFrame[] framesStartingWithRootEndingWithThis;
    private final RigidBodyTransform transformToParent;
    static long nextTransformToRootID = 1L;
    long transformToRootID = Long.MIN_VALUE;
    private final RigidBodyTransform transformToRoot;
    private final boolean isAStationaryFrame;
    private final boolean isZupFrame;

    public ReferenceFrame(String frameName) {
        this(frameName, null, null, true, true);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        this(frameName, parentFrame, null, false, false);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame, boolean isAStationaryFrame, boolean isZupFrame) {
        this(frameName, parentFrame, null, isAStationaryFrame, isZupFrame);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        this(frameName, parentFrame, transformToParent, false, false);
    }

    public ReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent, boolean isAStationaryFrame, boolean isZupFrame) {
        if (frameName.contains(SEPARATOR)) {
            throw new RuntimeException("A reference frame name can not contain ':'. Tried to construct a frame with name " + frameName + ".");
        }
        this.frameName = frameName;
        this.parentFrame = parentFrame;
        this.framesStartingWithRootEndingWithThis = ReferenceFrameTools.createPathFromRoot(this);
        if (parentFrame == null) {
            this.transformToRootID = 0L;
            this.nameId = frameName;
            this.frameIndex = 0L;
            this.transformToRoot = null;
            this.transformToParent = null;
            this.isAStationaryFrame = true;
            this.isZupFrame = true;
        } else {
            parentFrame.checkIfRemoved();
            this.nameId = parentFrame.nameId + SEPARATOR + frameName;
            this.frameIndex = parentFrame.incrementFramesAdded();
            parentFrame.children.add(new WeakReference<ReferenceFrame>(this));
            this.transformToRoot = new RigidBodyTransform();
            this.transformToParent = new RigidBodyTransform();
            if (transformToParent != null) {
                this.transformToParent.set(transformToParent);
                this.transformToParent.normalizeRotationPart();
            }
            if (isAStationaryFrame && !parentFrame.isAStationaryFrame) {
                throw new IllegalArgumentException("The child of a non-stationary frame cannot be stationary.");
            }
            this.isAStationaryFrame = isAStationaryFrame;
            this.isZupFrame = isZupFrame;
        }
    }

    private long incrementFramesAdded() {
        ++this.framesAddedToTree;
        if (this.parentFrame == null) {
            return this.framesAddedToTree;
        }
        return this.parentFrame.incrementFramesAdded();
    }

    public boolean isWorldFrame() {
        this.checkIfRemoved();
        return this == ReferenceFrameTools.getWorldFrame();
    }

    public boolean isRootFrame() {
        this.checkIfRemoved();
        return this.parentFrame == null;
    }

    public boolean isAStationaryFrame() {
        this.checkIfRemoved();
        return this.isAStationaryFrame;
    }

    public boolean isZupFrame() {
        this.checkIfRemoved();
        return this.isZupFrame;
    }

    public void update() {
        this.checkIfRemoved();
        if (this.parentFrame == null) {
            return;
        }
        this.updateTransformToParent(this.transformToParent);
        this.transformToRootID = Long.MIN_VALUE;
    }

    protected abstract void updateTransformToParent(RigidBodyTransform var1);

    public ReferenceFrame getParent() {
        this.checkIfRemoved();
        return this.parentFrame;
    }

    public ReferenceFrame getRootFrame() {
        this.checkIfRemoved();
        return this.framesStartingWithRootEndingWithThis[0];
    }

    public RigidBodyTransform getTransformToParent() {
        RigidBodyTransform transformToReturn = new RigidBodyTransform();
        this.getTransformToParent(transformToReturn);
        return transformToReturn;
    }

    public void getTransformToParent(RigidBodyTransform transformToPack) {
        this.checkIfRemoved();
        transformToPack.set(this.transformToParent);
    }

    public String getName() {
        this.checkIfRemoved();
        return this.frameName;
    }

    public RigidBodyTransform getTransformToDesiredFrame(ReferenceFrame desiredFrame) {
        RigidBodyTransform ret = new RigidBodyTransform();
        this.getTransformToDesiredFrame(ret, desiredFrame);
        return ret;
    }

    public RigidBodyTransform getTransformToWorldFrame() {
        RigidBodyTransform ret = new RigidBodyTransform();
        this.getTransformToDesiredFrame(ret, ReferenceFrameTools.getWorldFrame());
        return ret;
    }

    public void getTransformToDesiredFrame(RigidBodyTransform transformToPack, ReferenceFrame desiredFrame) {
        this.checkIfRemoved();
        try {
            if (this == desiredFrame) {
                transformToPack.setIdentity();
                return;
            }
            this.verifySameRoots(desiredFrame);
            if (this.isRootFrame()) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.getTransformToRoot());
            } else if (desiredFrame.isRootFrame()) {
                transformToPack.set(this.getTransformToRoot());
            } else if (this.isParentFrame(desiredFrame)) {
                transformToPack.set(this.transformToParent);
            } else if (desiredFrame.isParentFrame(this)) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.transformToParent);
            } else if (this.parentFrame == desiredFrame.parentFrame) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.transformToParent);
                transformToPack.multiply((RigidBodyTransformReadOnly)this.transformToParent);
            } else if (this.parentFrame.parentFrame == desiredFrame) {
                transformToPack.set(this.transformToParent);
                if (!this.parentFrame.isRootFrame()) {
                    transformToPack.preMultiply((RigidBodyTransformReadOnly)this.parentFrame.transformToParent);
                }
            } else if (this == desiredFrame.parentFrame.parentFrame) {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.transformToParent);
                if (!desiredFrame.parentFrame.isRootFrame()) {
                    transformToPack.multiplyInvertOther((RigidBodyTransformReadOnly)desiredFrame.parentFrame.transformToParent);
                }
            } else {
                transformToPack.setAndInvert((RigidBodyTransformReadOnly)desiredFrame.getTransformToRoot());
                transformToPack.multiply((RigidBodyTransformReadOnly)this.getTransformToRoot());
            }
        }
        catch (NotARotationMatrixException e) {
            throw new NotARotationMatrixException("Caught exception, this frame: " + this.frameName + ", other frame: " + desiredFrame.getName() + ", exception:\n" + e.getMessage());
        }
    }

    public boolean isParentFrame(ReferenceFrame frame) {
        this.checkIfRemoved();
        return frame == this.parentFrame;
    }

    public boolean isChildFrame(ReferenceFrame frame) {
        this.checkIfRemoved();
        return frame.isParentFrame(this);
    }

    public void verifySameRoots(ReferenceFrame referenceFrame) {
        if (this.getRootFrame() != referenceFrame.getRootFrame()) {
            throw new RuntimeException("Frames do not have same roots. this = " + this + ", referenceFrame = " + referenceFrame);
        }
    }

    public void transformFromThisToDesiredFrame(ReferenceFrame desiredFrame, Transformable objectToTransform) {
        this.checkIfRemoved();
        if (this == desiredFrame) {
            return;
        }
        this.verifySameRoots(desiredFrame);
        if (this.isRootFrame()) {
            objectToTransform.applyInverseTransform((Transform)desiredFrame.getTransformToRoot());
        } else if (desiredFrame.isRootFrame()) {
            objectToTransform.applyTransform((Transform)this.getTransformToRoot());
        } else if (this.isParentFrame(desiredFrame)) {
            objectToTransform.applyTransform((Transform)this.transformToParent);
        } else if (desiredFrame.isParentFrame(this)) {
            objectToTransform.applyInverseTransform((Transform)desiredFrame.transformToParent);
        } else if (this.parentFrame == desiredFrame.parentFrame) {
            objectToTransform.applyTransform((Transform)this.transformToParent);
            objectToTransform.applyInverseTransform((Transform)desiredFrame.transformToParent);
        } else if (this.parentFrame.parentFrame == desiredFrame) {
            objectToTransform.applyTransform((Transform)this.transformToParent);
            if (!this.parentFrame.isRootFrame()) {
                objectToTransform.applyTransform((Transform)this.parentFrame.transformToParent);
            }
        } else if (this == desiredFrame.parentFrame.parentFrame) {
            if (!desiredFrame.parentFrame.isRootFrame()) {
                objectToTransform.applyInverseTransform((Transform)desiredFrame.parentFrame.transformToParent);
            }
            objectToTransform.applyInverseTransform((Transform)desiredFrame.transformToParent);
        } else {
            objectToTransform.applyTransform((Transform)this.getTransformToRoot());
            objectToTransform.applyInverseTransform((Transform)desiredFrame.getTransformToRoot());
        }
    }

    public RigidBodyTransform getTransformToRoot() {
        this.efficientComputeTransform();
        return this.transformToRoot;
    }

    private void efficientComputeTransform() {
        this.checkIfRemoved();
        int chainLength = this.framesStartingWithRootEndingWithThis.length;
        boolean updateFromHereOnOut = false;
        long previousUpdateId = 0L;
        for (int i = 0; i < chainLength; ++i) {
            ReferenceFrame referenceFrame = this.framesStartingWithRootEndingWithThis[i];
            if (!updateFromHereOnOut && referenceFrame.transformToRootID < previousUpdateId) {
                updateFromHereOnOut = true;
                ++nextTransformToRootID;
            }
            if (updateFromHereOnOut && referenceFrame.parentFrame != null) {
                RigidBodyTransform parentsTransformToRoot = referenceFrame.parentFrame.transformToRoot;
                if (parentsTransformToRoot != null) {
                    referenceFrame.transformToRoot.set(parentsTransformToRoot);
                } else {
                    referenceFrame.transformToRoot.setIdentity();
                }
                referenceFrame.transformToRoot.multiply((RigidBodyTransformReadOnly)referenceFrame.transformToParent);
                referenceFrame.transformToRoot.normalizeRotationPart();
                referenceFrame.transformToRootID = nextTransformToRootID;
            }
            previousUpdateId = referenceFrame.transformToRootID;
        }
    }

    public String toString() {
        this.checkIfRemoved();
        return this.frameName;
    }

    public void checkReferenceFrameMatch(ReferenceFrameHolder referenceFrameHolder) throws ReferenceFrameMismatchException {
        this.checkReferenceFrameMatch(referenceFrameHolder.getReferenceFrame());
    }

    public void checkReferenceFrameMatch(ReferenceFrame referenceFrame) throws ReferenceFrameMismatchException {
        this.checkIfRemoved();
        if (this != referenceFrame) {
            String msg = "Argument's frame " + referenceFrame + " does not match " + this;
            throw new ReferenceFrameMismatchException(msg);
        }
    }

    public void checkIsWorldFrame() throws RuntimeException {
        this.checkIfRemoved();
        if (!this.isWorldFrame()) {
            throw new RuntimeException("Frame " + this + " is not world frame.");
        }
    }

    public void checkIsAStationaryFrame() throws RuntimeException {
        this.checkIfRemoved();
        if (!this.isAStationaryFrame()) {
            throw new RuntimeException("Frame " + this + " is not a stationary frame.");
        }
    }

    public void checkIsAZUpFrame() throws RuntimeException {
        this.checkIfRemoved();
        if (!this.isZupFrame()) {
            throw new RuntimeException("Frame " + this + " is not a z-up frame.");
        }
    }

    public int hashCode() {
        this.checkIfRemoved();
        return this.nameId.hashCode();
    }

    public boolean equals(Object other) {
        this.checkIfRemoved();
        if (other instanceof ReferenceFrame) {
            return ((ReferenceFrame)other).nameId.equals(this.nameId);
        }
        return false;
    }

    public long getFrameIndex() {
        this.checkIfRemoved();
        return this.frameIndex;
    }

    public long getAdditionalNameBasedHashCode() {
        this.checkIfRemoved();
        return this.additionalNameBasedHashCode;
    }

    public void setAdditionalNameBasedHashCode(long additionalNameBasedHashCode) {
        this.checkIfRemoved();
        this.additionalNameBasedHashCode = additionalNameBasedHashCode;
    }

    private void checkIfRemoved() {
        if (this.hasBeenRemoved) {
            throw new RuntimeException("Can not use frame that was removed from the frame tree.");
        }
    }

    public void remove() {
        if (!this.hasBeenRemoved && this.parentFrame != null) {
            for (int i = 0; i < this.parentFrame.children.size(); ++i) {
                if (this.parentFrame.children.get(i).get() != this) continue;
                this.parentFrame.children.remove(i);
                break;
            }
            this.disableRecursivly();
        }
    }

    private void updateChildren() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (this.children.get(i).get() != null) continue;
            this.children.remove(i);
        }
    }

    public void clearChildren() {
        this.checkIfRemoved();
        this.children.stream().map(Reference::get).filter(child -> child != null).forEach(child -> child.disableRecursivly());
        this.children.clear();
        if (this.isRootFrame()) {
            this.framesAddedToTree = 0L;
        }
    }

    private void disableRecursivly() {
        this.hasBeenRemoved = true;
        this.children.stream().map(Reference::get).filter(child -> child != null).forEach(child -> child.disableRecursivly());
    }

    public int getNumberOfChildren() {
        this.checkIfRemoved();
        this.updateChildren();
        return this.children.size();
    }

    public ReferenceFrame getChild(int index) {
        this.checkIfRemoved();
        return (ReferenceFrame)this.children.get(index).get();
    }

    public ReferenceFrame[] getFramesStartingWithRootEndingWithThis() {
        this.checkIfRemoved();
        return this.framesStartingWithRootEndingWithThis;
    }

    public static ReferenceFrame getWorldFrame() {
        return ReferenceFrameTools.getWorldFrame();
    }
}

