/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.List;
import java.util.Random;
import us.ihmc.euclid.referenceFrame.FixedFrameShape3DPose;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.FrameCapsule3D;
import us.ihmc.euclid.referenceFrame.FrameCylinder3D;
import us.ihmc.euclid.referenceFrame.FrameEllipsoid3D;
import us.ihmc.euclid.referenceFrame.FramePointShape3D;
import us.ihmc.euclid.referenceFrame.FrameRamp3D;
import us.ihmc.euclid.referenceFrame.FrameShape3DPose;
import us.ihmc.euclid.referenceFrame.FrameSphere3D;
import us.ihmc.euclid.referenceFrame.FrameTorus3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.FrameConvexPolytope3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameFace3D;
import us.ihmc.euclid.referenceFrame.polytope.FrameVertex3D;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidFrameShapeRandomTools {
    private EuclidFrameShapeRandomTools() {
    }

    public static FrameShape3DPose nextFrameShape3DPose(Random random, ReferenceFrame referenceFrame) {
        return new FrameShape3DPose(referenceFrame, (RigidBodyTransformReadOnly)EuclidShapeRandomTools.nextShape3DPose((Random)random));
    }

    public static FixedFrameShape3DPose nextFixedFrameShape3DPose(Random random, ReferenceFrame referenceFrame) {
        return new FixedFrameShape3DPose(() -> referenceFrame, (RigidBodyTransformReadOnly)EuclidShapeRandomTools.nextShape3DPose((Random)random));
    }

    public static FrameBox3D nextFrameBox3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameBox3D(referenceFrame, (Box3DReadOnly)EuclidShapeRandomTools.nextBox3D((Random)random));
    }

    public static FrameBox3D nextFrameBox3D(Random random, ReferenceFrame referenceFrame, double minSize, double maxSize) {
        return new FrameBox3D(referenceFrame, (Box3DReadOnly)EuclidShapeRandomTools.nextBox3D((Random)random, (double)minSize, (double)maxSize));
    }

    public static FrameCapsule3D nextFrameCapsule3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameCapsule3D(referenceFrame, (Capsule3DReadOnly)EuclidShapeRandomTools.nextCapsule3D((Random)random));
    }

    public static FrameCapsule3D nextFrameCapsule3D(Random random, ReferenceFrame referenceFrame, double minLength, double maxLength, double minRadius, double maxRadius) {
        return new FrameCapsule3D(referenceFrame, (Capsule3DReadOnly)EuclidShapeRandomTools.nextCapsule3D((Random)random, (double)minLength, (double)maxLength, (double)minRadius, (double)maxRadius));
    }

    public static FrameCylinder3D nextFrameCylinder3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameCylinder3D(referenceFrame, (Cylinder3DReadOnly)EuclidShapeRandomTools.nextCylinder3D((Random)random));
    }

    public static FrameCylinder3D nextFrameCylinder3D(Random random, ReferenceFrame referenceFrame, double minLength, double maxLength, double minRadius, double maxRadius) {
        return new FrameCylinder3D(referenceFrame, (Cylinder3DReadOnly)EuclidShapeRandomTools.nextCylinder3D((Random)random, (double)minLength, (double)maxLength, (double)minRadius, (double)maxRadius));
    }

    public static FrameEllipsoid3D nextFrameEllipsoid3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameEllipsoid3D(referenceFrame, (Ellipsoid3DReadOnly)EuclidShapeRandomTools.nextEllipsoid3D((Random)random));
    }

    public static FrameEllipsoid3D nextFrameEllipsoid3D(Random random, ReferenceFrame referenceFrame, double minRadius, double maxRadius) {
        return new FrameEllipsoid3D(referenceFrame, (Ellipsoid3DReadOnly)EuclidShapeRandomTools.nextEllipsoid3D((Random)random, (double)minRadius, (double)maxRadius));
    }

    public static FramePointShape3D nextFramePointShape3D(Random random, ReferenceFrame referenceFrame) {
        return new FramePointShape3D((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)referenceFrame));
    }

    public static FramePointShape3D nextFramePointShape3D(Random random, ReferenceFrame referenceFrame, double minMax) {
        return new FramePointShape3D((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)referenceFrame, (double)minMax));
    }

    public static FrameRamp3D nextFrameRamp3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameRamp3D(referenceFrame, (Ramp3DReadOnly)EuclidShapeRandomTools.nextRamp3D((Random)random));
    }

    public static FrameRamp3D nextFrameRamp3D(Random random, ReferenceFrame referenceFrame, double minSize, double maxSize) {
        return new FrameRamp3D(referenceFrame, (Ramp3DReadOnly)EuclidShapeRandomTools.nextRamp3D((Random)random, (double)minSize, (double)maxSize));
    }

    public static FrameSphere3D nextFrameSphere3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameSphere3D(referenceFrame, (Sphere3DReadOnly)EuclidShapeRandomTools.nextSphere3D((Random)random));
    }

    public static FrameSphere3D nextFrameSphere3D(Random random, ReferenceFrame referenceFrame, double minRadius, double maxRadius) {
        return new FrameSphere3D(referenceFrame, (Sphere3DReadOnly)EuclidShapeRandomTools.nextSphere3D((Random)random, (double)minRadius, (double)maxRadius));
    }

    public static FrameTorus3D nextFrameTorus3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameTorus3D(referenceFrame, (Torus3DReadOnly)EuclidShapeRandomTools.nextTorus3D((Random)random));
    }

    public static FrameTorus3D nextFrameTorus3D(Random random, ReferenceFrame referenceFrame, double minRadius, double maxRadius, double minTubeRadius, double maxTubeRadius) {
        return new FrameTorus3D(referenceFrame, (Torus3DReadOnly)EuclidShapeRandomTools.nextTorus3D((Random)random, (double)minRadius, (double)maxRadius, (double)minTubeRadius, (double)maxTubeRadius));
    }

    public static FrameFace3D nextCircleBasedFrameFace3D(Random random, ReferenceFrame referenceFrame) {
        return EuclidFrameShapeRandomTools.nextCircleBasedFrameFace3D(random, referenceFrame, 5.0);
    }

    public static FrameFace3D nextCircleBasedFrameFace3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return EuclidFrameShapeRandomTools.nextCircleBasedFrameFace3D(random, referenceFrame, centerMinMax, 1.0, 15);
    }

    public static FrameFace3D nextCircleBasedFrameFace3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double maxEdgeLength, int numberOfVertices) {
        return EuclidFrameShapeRandomTools.nextCircleBasedFrameFace3D(random, referenceFrame, centerMinMax, maxEdgeLength, numberOfVertices, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
    }

    public static FrameFace3D nextCircleBasedFrameFace3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double maxEdgeLength, int numberOfVertices, Vector3DReadOnly faceNormal) {
        List vertices = EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D((Random)random, (double)centerMinMax, (double)maxEdgeLength, (int)numberOfVertices, (Vector3DReadOnly)faceNormal);
        FrameFace3D face3D = new FrameFace3D(() -> referenceFrame, faceNormal);
        vertices.forEach(vertex -> face3D.addVertex(new FrameVertex3D(face3D, (Point3DReadOnly)vertex)));
        return face3D;
    }

    public static FrameConvexPolytope3D nextFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextFrameConvexPolytope3DWithEdgeCases(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConvexPolytope3DWithEdgeCases((Random)random));
    }

    public static FrameConvexPolytope3D nextConeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextConeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextConeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double heightMin, double heightMax, double radiusMin, double radiusMax, int divisionsMin, int divisionsMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextConeConvexPolytope3D((Random)random, (double)centerMinMax, (double)heightMin, (double)heightMax, (double)radiusMin, (double)radiusMax, (int)divisionsMin, (int)divisionsMax));
    }

    public static FrameConvexPolytope3D nextCubeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextCubeConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextCubeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextCubeConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextCubeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double edgeLengthMin, double edgeLengthMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextCubeConvexPolytope3D((Random)random, (double)centerMinMax, (double)edgeLengthMin, (double)edgeLengthMax));
    }

    public static FrameConvexPolytope3D nextCylinderFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextCylinderConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextCylinderFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextCylinderConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextCylinderFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double lengthMin, double lengthMax, double radiusMin, double radiusMax, int divisionsMin, int divisionsMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextCylinderConvexPolytope3D((Random)random, (double)centerMinMax, (double)lengthMin, (double)lengthMax, (double)radiusMin, (double)radiusMax, (int)divisionsMin, (int)divisionsMax));
    }

    public static FrameConvexPolytope3D nextIcosahedronBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextIcosahedronBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextIcosahedronBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double radiusMin, double radiusMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextIcosahedronBasedConvexPolytope3D((Random)random, (double)centerMinMax, (double)radiusMin, (double)radiusMax));
    }

    public static FrameConvexPolytope3D nextIcoSphereBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextIcoSphereBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextIcoSphereBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double radiusMin, double radiusMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random, (double)centerMinMax, (double)radiusMin, (double)radiusMax));
    }

    public static FrameConvexPolytope3D nextIcoSphereBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, int recursionLevel, double radiusMin, double radiusMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextIcoSphereBasedConvexPolytope3D((Random)random, (double)centerMinMax, (int)recursionLevel, (double)radiusMin, (double)radiusMax));
    }

    public static FrameConvexPolytope3D nextPointCloudBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextPointCloudBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextPointCloudBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double minMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D((Random)random, (double)centerMinMax, (double)minMax));
    }

    public static FrameConvexPolytope3D nextPointCloudBasedFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double minMax, int numberOfPossiblePoints) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextPointCloudBasedConvexPolytope3D((Random)random, (double)centerMinMax, (double)minMax, (int)numberOfPossiblePoints));
    }

    public static FrameConvexPolytope3D nextPyramidFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextPyramidConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextPyramidFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextPyramidConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextPyramidFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double heightMin, double heightMax, double baseLengthMin, double baseLengthMax, double baseWidthMin, double baseWidthMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextPyramidConvexPolytope3D((Random)random, (double)centerMinMax, (double)heightMin, (double)heightMax, (double)baseLengthMin, (double)baseLengthMax, (double)baseWidthMin, (double)baseWidthMax));
    }

    public static FrameConvexPolytope3D nextSingleEdgeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextSingleEdgeConvexPolytope3D((Random)random));
    }

    public static FrameConvexPolytope3D nextSingleEdgeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextSingleEdgeConvexPolytope3D((Random)random, (double)centerMinMax));
    }

    public static FrameConvexPolytope3D nextSingleEdgeFrameConvexPolytope3D(Random random, ReferenceFrame referenceFrame, double centerMinMax, double minMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextSingleEdgeConvexPolytope3D((Random)random, (double)centerMinMax, (double)minMax));
    }

    public static FrameConvexPolytope3D nextFrameTetrahedronContainingPoint3D(Random random, ReferenceFrame referenceFrame, Point3DReadOnly point) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)point));
    }

    public static FrameConvexPolytope3D nextFrameTetrahedronContainingPoint3D(Random random, ReferenceFrame referenceFrame, Point3DReadOnly point, double minMax) {
        return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)point, (double)minMax));
    }

    public static FrameShape3DBasics nextFrameShape3D(Random random, ReferenceFrame referenceFrame) {
        switch (random.nextInt(8)) {
            case 0: {
                return EuclidFrameShapeRandomTools.nextFrameBox3D(random, referenceFrame);
            }
            case 1: {
                return EuclidFrameShapeRandomTools.nextFrameCapsule3D(random, referenceFrame);
            }
            case 2: {
                return EuclidFrameShapeRandomTools.nextFrameConvexPolytope3D(random, referenceFrame);
            }
            case 3: {
                return EuclidFrameShapeRandomTools.nextFrameCylinder3D(random, referenceFrame);
            }
            case 4: {
                return EuclidFrameShapeRandomTools.nextFrameEllipsoid3D(random, referenceFrame);
            }
            case 5: {
                return EuclidFrameShapeRandomTools.nextFramePointShape3D(random, referenceFrame);
            }
            case 6: {
                return EuclidFrameShapeRandomTools.nextFrameRamp3D(random, referenceFrame);
            }
            case 7: {
                return EuclidFrameShapeRandomTools.nextFrameSphere3D(random, referenceFrame);
            }
        }
        throw new RuntimeException("Unexpected state.");
    }

    public static FrameShape3DBasics nextFrameConvexShape3D(Random random, ReferenceFrame referenceFrame) {
        switch (random.nextInt(8)) {
            case 0: {
                return EuclidFrameShapeRandomTools.nextFrameBox3D(random, referenceFrame);
            }
            case 1: {
                return EuclidFrameShapeRandomTools.nextFrameCapsule3D(random, referenceFrame);
            }
            case 2: {
                return EuclidFrameShapeRandomTools.nextFrameConvexPolytope3D(random, referenceFrame);
            }
            case 3: {
                return EuclidFrameShapeRandomTools.nextFrameCylinder3D(random, referenceFrame);
            }
            case 4: {
                return EuclidFrameShapeRandomTools.nextFrameEllipsoid3D(random, referenceFrame);
            }
            case 5: {
                return EuclidFrameShapeRandomTools.nextFramePointShape3D(random, referenceFrame);
            }
            case 6: {
                return EuclidFrameShapeRandomTools.nextFrameRamp3D(random, referenceFrame);
            }
            case 7: {
                return EuclidFrameShapeRandomTools.nextFrameSphere3D(random, referenceFrame);
            }
        }
        throw new RuntimeException("Unexpected state.");
    }

    public static FrameShape3DBasics nextFrameConvexShape3D(Random random, ReferenceFrame referenceFrame, Tuple3DReadOnly shapeCentroid) {
        Shape3DBasics next = EuclidShapeRandomTools.nextConvexShape3D((Random)random, (Tuple3DReadOnly)shapeCentroid);
        if (next instanceof Box3DReadOnly) {
            return new FrameBox3D(referenceFrame, (Box3DReadOnly)next);
        }
        if (next instanceof Capsule3DReadOnly) {
            return new FrameCapsule3D(referenceFrame, (Capsule3DReadOnly)next);
        }
        if (next instanceof ConvexPolytope3DReadOnly) {
            return new FrameConvexPolytope3D(referenceFrame, (ConvexPolytope3DReadOnly)next);
        }
        if (next instanceof Cylinder3DReadOnly) {
            return new FrameCylinder3D(referenceFrame, (Cylinder3DReadOnly)next);
        }
        if (next instanceof Ellipsoid3DReadOnly) {
            return new FrameEllipsoid3D(referenceFrame, (Ellipsoid3DReadOnly)next);
        }
        if (next instanceof PointShape3DReadOnly) {
            return new FramePointShape3D(referenceFrame, shapeCentroid);
        }
        if (next instanceof Ramp3DReadOnly) {
            return new FrameRamp3D(referenceFrame, (Ramp3DReadOnly)next);
        }
        if (next instanceof Sphere3DReadOnly) {
            return new FrameSphere3D(referenceFrame, (Sphere3DReadOnly)next);
        }
        throw new RuntimeException("Unexpected state.");
    }
}

