/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.FrameBoundingBox3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.interfaces.SupportingFrameVertexHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface FrameShape3DReadOnly
extends Shape3DReadOnly,
SupportingFrameVertexHolder,
EuclidFrameGeometry {
    public FramePoint3DReadOnly getCentroid();

    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, FixedFramePoint3DBasics closestPointOnSurfaceToPack, FixedFrameVector3DBasics normalAtClosestPointToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)closestPointOnSurfaceToPack);
        this.checkReferenceFrameMatch((ReferenceFrameHolder)normalAtClosestPointToPack);
        return this.evaluatePoint3DCollision(pointToCheck, (Point3DBasics)closestPointOnSurfaceToPack, (Vector3DBasics)normalAtClosestPointToPack);
    }

    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, FramePoint3DBasics closestPointOnSurfaceToPack, FrameVector3DBasics normalAtClosestPointToPack) {
        closestPointOnSurfaceToPack.setReferenceFrame(this.getReferenceFrame());
        normalAtClosestPointToPack.setReferenceFrame(this.getReferenceFrame());
        return this.evaluatePoint3DCollision(pointToCheck, (Point3DBasics)closestPointOnSurfaceToPack, (Vector3DBasics)normalAtClosestPointToPack);
    }

    default public boolean evaluatePoint3DCollision(FramePoint3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToCheck);
        return this.evaluatePoint3DCollision((Point3DReadOnly)pointToCheck, closestPointOnSurfaceToPack, normalAtClosestPointToPack);
    }

    default public boolean evaluatePoint3DCollision(FramePoint3DReadOnly pointToCheck, FixedFramePoint3DBasics closestPointOnSurfaceToPack, FixedFrameVector3DBasics normalAtClosestPointToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToCheck);
        return this.evaluatePoint3DCollision((Point3DReadOnly)pointToCheck, closestPointOnSurfaceToPack, normalAtClosestPointToPack);
    }

    default public boolean evaluatePoint3DCollision(FramePoint3DReadOnly pointToCheck, FramePoint3DBasics closestPointOnSurfaceToPack, FrameVector3DBasics normalAtClosestPointToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToCheck);
        return this.evaluatePoint3DCollision((Point3DReadOnly)pointToCheck, closestPointOnSurfaceToPack, normalAtClosestPointToPack);
    }

    default public double distance(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        return this.distance((Point3DReadOnly)point);
    }

    default public double signedDistance(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        return this.signedDistance((Point3DReadOnly)point);
    }

    default public boolean isPointInside(FramePoint3DReadOnly query) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return this.isPointInside((Point3DReadOnly)query);
    }

    default public boolean isPointInside(FramePoint3DReadOnly query, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)query);
        return this.isPointInside((Point3DReadOnly)query, epsilon);
    }

    default public FramePoint3DBasics orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        FramePoint3D projection = new FramePoint3D();
        if (this.orthogonalProjection(pointToProject, (FramePoint3DBasics)projection)) {
            return projection;
        }
        return null;
    }

    default public FramePoint3DBasics orthogonalProjectionCopy(FramePoint3DReadOnly pointToProject) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject);
        return this.orthogonalProjectionCopy((Point3DReadOnly)pointToProject);
    }

    default public boolean orthogonalProjection(FixedFramePoint3DBasics pointToProject) {
        return this.orthogonalProjection((FramePoint3DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(FramePoint3DBasics pointToProject) {
        return this.orthogonalProjection((FramePoint3DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, FixedFramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)projectionToPack);
        return this.orthogonalProjection(pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return this.orthogonalProjection(pointToProject, (Point3DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject);
        return this.orthogonalProjection((Point3DReadOnly)pointToProject, projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FixedFramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject);
        return this.orthogonalProjection((Point3DReadOnly)pointToProject, projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject);
        return this.orthogonalProjection((Point3DReadOnly)pointToProject, projectionToPack);
    }

    default public FrameBoundingBox3DReadOnly getBoundingBox() {
        FrameBoundingBox3D boundingBox3D = new FrameBoundingBox3D();
        this.getBoundingBox((FrameBoundingBox3DBasics)boundingBox3D);
        return boundingBox3D;
    }

    default public FrameBoundingBox3DReadOnly getBoundingBox(ReferenceFrame destinationFrame) {
        FrameBoundingBox3D boundingBox3D = new FrameBoundingBox3D();
        this.getBoundingBox(destinationFrame, (FrameBoundingBox3DBasics)boundingBox3D);
        return boundingBox3D;
    }

    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        this.getBoundingBox(this.getReferenceFrame(), boundingBoxToPack);
    }

    default public void getBoundingBox(FixedFrameBoundingBox3DBasics boundingBoxToPack) {
        this.getBoundingBox(boundingBoxToPack.getReferenceFrame(), (BoundingBox3DBasics)boundingBoxToPack);
    }

    default public void getBoundingBox(FrameBoundingBox3DBasics boundingBoxToPack) {
        this.getBoundingBox(this.getReferenceFrame(), boundingBoxToPack);
    }

    public void getBoundingBox(ReferenceFrame var1, BoundingBox3DBasics var2);

    default public void getBoundingBox(ReferenceFrame destinationFrame, FrameBoundingBox3DBasics boundingBoxToPack) {
        boundingBoxToPack.setReferenceFrame(destinationFrame);
        this.getBoundingBox(destinationFrame, (BoundingBox3DBasics)boundingBoxToPack);
    }

    public FrameShape3DPoseReadOnly getPose();

    public FixedFrameShape3DBasics copy();
}

