/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidFrameShapeCollisionTools {
    private EuclidFrameShapeCollisionTools() {
    }

    public static void evaluatePointShape3DBox3DCollision(FramePointShape3DReadOnly shapeA, FrameBox3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DBox3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
    }

    public static void evaluateSphere3DBox3DCollision(FrameSphere3DReadOnly shapeA, FrameBox3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DBox3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (FrameTuple3DReadOnly)resultToPack.getNormalOnA(), (FrameTuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setSignedDistance(distance);
        resultToPack.setShapesAreColliding(distance < 0.0);
    }

    private static void evaluatePoint3DBox3DCollision(FramePoint3DReadOnly point3D, FrameBox3DReadOnly box3D, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)point3D);
        ReferenceFrame boxFrame = box3D.getReferenceFrame();
        pointOnA.changeFrame(boxFrame);
        double pointInBBackupX = pointOnA.getX();
        double pointInBBackupY = pointOnA.getY();
        double pointInBBackupZ = pointOnA.getZ();
        box3D.transformToLocal((Transformable)pointOnA);
        double distance = EuclidShapeTools.evaluatePoint3DBox3DCollision((Point3DReadOnly)pointOnA, (Vector3DReadOnly)box3D.getSize(), (Point3DBasics)pointOnB, (Vector3DBasics)normalOnB);
        pointOnB.setReferenceFrame(boxFrame);
        normalOnB.setReferenceFrame(boxFrame);
        normalOnA.setReferenceFrame(boxFrame);
        box3D.transformToWorld((Transformable)pointOnB);
        box3D.transformToWorld((Transformable)normalOnB);
        pointOnA.setIncludingFrame(boxFrame, pointInBBackupX, pointInBBackupY, pointInBBackupZ);
        normalOnA.setAndNegate((FrameTuple3DReadOnly)normalOnB);
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DCapsule3DCollision(FramePointShape3DReadOnly shapeA, FrameCapsule3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DCapsule3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
    }

    public static void evaluateCapsule3DCapsule3DCollision(FrameCapsule3DReadOnly shapeA, FrameCapsule3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        ReferenceFrame frameB = shapeB.getReferenceFrame();
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)shapeA.getTopCenter());
        pointOnA.changeFrame(frameB);
        double topAX = pointOnA.getX();
        double topAY = pointOnA.getY();
        double topAZ = pointOnA.getZ();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)shapeA.getBottomCenter());
        pointOnA.changeFrame(frameB);
        double bottomAX = pointOnA.getX();
        double bottomAY = pointOnA.getY();
        double bottomAZ = pointOnA.getZ();
        FramePoint3DReadOnly topCenterB = shapeB.getTopCenter();
        double topBX = topCenterB.getX();
        double topBY = topCenterB.getY();
        double topBZ = topCenterB.getZ();
        FramePoint3DReadOnly bottomCenterB = shapeB.getBottomCenter();
        double bottomBX = bottomCenterB.getX();
        double bottomBY = bottomCenterB.getY();
        double bottomBZ = bottomCenterB.getZ();
        double distanceBetweenAxes = EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((double)topAX, (double)topAY, (double)topAZ, (double)bottomAX, (double)bottomAY, (double)bottomAZ, (double)topBX, (double)topBY, (double)topBZ, (double)bottomBX, (double)bottomBY, (double)bottomBZ, (Point3DBasics)pointOnA, (Point3DBasics)pointOnB);
        pointOnA.setReferenceFrame(frameB);
        pointOnB.setReferenceFrame(frameB);
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        normalOnA.setReferenceFrame(frameB);
        normalOnB.setReferenceFrame(frameB);
        normalOnA.sub((FrameTuple3DReadOnly)pointOnB, (FrameTuple3DReadOnly)pointOnA);
        normalOnA.scale(1.0 / distanceBetweenAxes);
        normalOnB.setAndNegate((FrameTuple3DReadOnly)normalOnA);
        pointOnA.scaleAdd(shapeA.getRadius(), (FrameTuple3DReadOnly)normalOnA, (FrameTuple3DReadOnly)pointOnA);
        pointOnB.scaleAdd(shapeB.getRadius(), (FrameTuple3DReadOnly)normalOnB, (FrameTuple3DReadOnly)pointOnB);
        double distance = distanceBetweenAxes - shapeA.getRadius() - shapeB.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
    }

    public static void evaluateSphere3DCapsule3DCollision(FrameSphere3DReadOnly shapeA, FrameCapsule3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DCapsule3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (FrameTuple3DReadOnly)resultToPack.getNormalOnA(), (FrameTuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DCapsule3DCollision(FramePoint3DReadOnly point3D, FrameCapsule3DReadOnly capsule3D, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)point3D);
        ReferenceFrame capsuleFrame = capsule3D.getReferenceFrame();
        pointOnA.changeFrame(capsuleFrame);
        double distance = EuclidShapeTools.evaluatePoint3DCapsule3DCollision((Point3DReadOnly)pointOnA, (Point3DReadOnly)capsule3D.getPosition(), (Vector3DReadOnly)capsule3D.getAxis(), (double)capsule3D.getLength(), (double)capsule3D.getRadius(), (Point3DBasics)pointOnB, (Vector3DBasics)normalOnB);
        pointOnB.setReferenceFrame(capsuleFrame);
        normalOnA.setReferenceFrame(capsuleFrame);
        normalOnB.setReferenceFrame(capsuleFrame);
        normalOnA.setAndNegate((FrameTuple3DReadOnly)normalOnB);
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DCylinder3DCollision(FramePointShape3DReadOnly shapeA, FrameCylinder3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DCylinder3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
    }

    public static void evaluateSphere3DCylinder3DCollision(FrameSphere3DReadOnly shapeA, FrameCylinder3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DCylinder3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (FrameTuple3DReadOnly)resultToPack.getNormalOnA(), (FrameTuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DCylinder3DCollision(FramePoint3DReadOnly point3D, FrameCylinder3DReadOnly cylinder3D, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)point3D);
        ReferenceFrame cylinderFrame = cylinder3D.getReferenceFrame();
        pointOnA.changeFrame(cylinderFrame);
        double distance = EuclidShapeTools.evaluatePoint3DCylinder3DCollision((Point3DReadOnly)pointOnA, (Point3DReadOnly)cylinder3D.getPosition(), (Vector3DReadOnly)cylinder3D.getAxis(), (double)cylinder3D.getLength(), (double)cylinder3D.getRadius(), (Point3DBasics)pointOnB, (Vector3DBasics)normalOnB);
        pointOnB.setReferenceFrame(cylinderFrame);
        normalOnA.setReferenceFrame(cylinderFrame);
        normalOnB.setReferenceFrame(cylinderFrame);
        normalOnA.setAndNegate((FrameTuple3DReadOnly)normalOnB);
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DEllipsoid3DCollision(FramePointShape3DReadOnly shapeA, FrameEllipsoid3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DEllipsoid3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
    }

    public static void evaluateSphere3DEllipsoid3DCollision(FrameSphere3DReadOnly shapeA, FrameEllipsoid3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DEllipsoid3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (FrameTuple3DReadOnly)resultToPack.getNormalOnA(), (FrameTuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DEllipsoid3DCollision(FramePoint3DReadOnly point3D, FrameEllipsoid3DReadOnly ellipsoid3D, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)point3D);
        ReferenceFrame ellipsoidFrame = ellipsoid3D.getReferenceFrame();
        pointOnA.changeFrame(ellipsoidFrame);
        double pointInBBackupX = pointOnA.getX();
        double pointInBBackupY = pointOnA.getY();
        double pointInBBackupZ = pointOnA.getZ();
        ellipsoid3D.transformToLocal((Transformable)pointOnA);
        double distance = EuclidShapeTools.evaluatePoint3DEllipsoid3DCollision((Point3DReadOnly)pointOnA, (Vector3DReadOnly)ellipsoid3D.getRadii(), (Point3DBasics)pointOnB, (Vector3DBasics)normalOnB);
        pointOnB.setReferenceFrame(ellipsoidFrame);
        normalOnA.setReferenceFrame(ellipsoidFrame);
        normalOnB.setReferenceFrame(ellipsoidFrame);
        ellipsoid3D.transformToWorld((Transformable)pointOnB);
        ellipsoid3D.transformToWorld((Transformable)normalOnB);
        pointOnA.setIncludingFrame(ellipsoidFrame, pointInBBackupX, pointInBBackupY, pointInBBackupZ);
        normalOnA.setAndNegate((FrameTuple3DReadOnly)normalOnB);
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DPointShape3DCollision(FramePointShape3DReadOnly shapeA, FramePointShape3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)shapeA);
        ReferenceFrame frameB = shapeB.getReferenceFrame();
        pointOnA.changeFrame(frameB);
        pointOnB.setIncludingFrame(frameB, (Tuple3DReadOnly)shapeB);
        double distance = pointOnA.distance((FramePoint3DReadOnly)shapeB);
        normalOnA.setReferenceFrame(frameB);
        normalOnA.sub((FrameTuple3DReadOnly)pointOnB, (FrameTuple3DReadOnly)pointOnA);
        normalOnB.setReferenceFrame(frameB);
        normalOnB.setAndNegate((FrameTuple3DReadOnly)normalOnA);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.setShapesAreColliding(false);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DRamp3DCollision(FramePointShape3DReadOnly shapeA, FrameRamp3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DRamp3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
    }

    public static void evaluateSphere3DRamp3DCollision(FrameSphere3DReadOnly shapeA, FrameRamp3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        EuclidFrameShapeCollisionTools.evaluatePoint3DRamp3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (FrameTuple3DReadOnly)resultToPack.getNormalOnA(), (FrameTuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DRamp3DCollision(FramePoint3DReadOnly point3D, FrameRamp3DReadOnly ramp3D, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)point3D);
        ReferenceFrame rampFrame = ramp3D.getReferenceFrame();
        pointOnA.changeFrame(rampFrame);
        double pointInBBackupX = pointOnA.getX();
        double pointInBBackupY = pointOnA.getY();
        double pointInBBackupZ = pointOnA.getZ();
        ramp3D.transformToLocal((Transformable)pointOnA);
        double distance = EuclidShapeTools.evaluatePoint3DRamp3DCollision((Point3DReadOnly)pointOnA, (Vector3DReadOnly)ramp3D.getSize(), (Point3DBasics)pointOnB, (Vector3DBasics)normalOnB);
        pointOnB.setReferenceFrame(rampFrame);
        normalOnA.setReferenceFrame(rampFrame);
        normalOnB.setReferenceFrame(rampFrame);
        ramp3D.transformToWorld((Transformable)pointOnB);
        ramp3D.transformToWorld((Transformable)normalOnB);
        pointOnA.setIncludingFrame(rampFrame, pointInBBackupX, pointInBBackupY, pointInBBackupZ);
        normalOnA.setAndNegate((FrameTuple3DReadOnly)normalOnB);
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DSphere3DCollision(FramePointShape3DReadOnly shapeA, FrameSphere3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)shapeA);
        ReferenceFrame frameB = shapeB.getReferenceFrame();
        pointOnA.changeFrame(frameB);
        double distance = EuclidShapeTools.evaluatePoint3DSphere3DCollision((Point3DReadOnly)pointOnA, (Point3DReadOnly)shapeB.getPosition(), (double)shapeB.getRadius(), (Point3DBasics)pointOnB, (Vector3DBasics)normalOnB);
        pointOnB.setReferenceFrame(frameB);
        normalOnA.setReferenceFrame(frameB);
        normalOnB.setReferenceFrame(frameB);
        normalOnA.setAndNegate((FrameTuple3DReadOnly)normalOnB);
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
        resultToPack.setFrameShapeA(shapeA);
        resultToPack.setFrameShapeB(shapeB);
    }

    public static void evaluateSphere3DSphere3DCollision(FrameSphere3DReadOnly shapeA, FrameSphere3DReadOnly shapeB, EuclidFrameShape3DCollisionResultBasics resultToPack) {
        FramePoint3DBasics pointOnA = resultToPack.getPointOnA();
        FramePoint3DBasics pointOnB = resultToPack.getPointOnB();
        FrameVector3DBasics normalOnA = resultToPack.getNormalOnA();
        FrameVector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.setIncludingFrame((FrameTuple3DReadOnly)shapeA.getPosition());
        ReferenceFrame frameB = shapeB.getReferenceFrame();
        pointOnA.changeFrame(frameB);
        double distance = EuclidShapeTools.evaluatePoint3DSphere3DCollision((Point3DReadOnly)pointOnA, (Point3DReadOnly)shapeB.getPosition(), (double)shapeB.getRadius(), (Point3DBasics)pointOnB, (Vector3DBasics)normalOnB);
        distance -= shapeA.getRadius();
        pointOnB.setReferenceFrame(frameB);
        normalOnA.setReferenceFrame(frameB);
        normalOnB.setReferenceFrame(frameB);
        normalOnA.setAndNegate((FrameTuple3DReadOnly)normalOnB);
        pointOnA.scaleAdd(shapeA.getRadius(), (FrameTuple3DReadOnly)normalOnA, (FrameTuple3DReadOnly)resultToPack.getPointOnA());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }
}

