/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTorus3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameConvexPolytope3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameFace3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameHalfEdge3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameVertex3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;

public class EuclidFrameShapeIOTools {
    private EuclidFrameShapeIOTools() {
    }

    public static String getFrameBox3DString(FrameBox3DReadOnly box3D) {
        return EuclidFrameShapeIOTools.getFrameBox3DString(EuclidCoreIOTools.DEFAULT_FORMAT, box3D);
    }

    public static String getFrameBox3DString(String format, FrameBox3DReadOnly box3D) {
        if (box3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getBox3DString((String)format, (Box3DReadOnly)box3D) + " - " + box3D.getReferenceFrame();
    }

    public static String getFrameCapsule3DString(FrameCapsule3DReadOnly capsule3D) {
        return EuclidFrameShapeIOTools.getFrameCapsule3DString(EuclidCoreIOTools.DEFAULT_FORMAT, capsule3D);
    }

    public static String getFrameCapsule3DString(String format, FrameCapsule3DReadOnly capsule3D) {
        if (capsule3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getCapsule3DString((String)format, (Capsule3DReadOnly)capsule3D) + " - " + capsule3D.getReferenceFrame();
    }

    public static String getFrameCylinder3DString(FrameCylinder3DReadOnly cylinder3D) {
        return EuclidFrameShapeIOTools.getFrameCylinder3DString(EuclidCoreIOTools.DEFAULT_FORMAT, cylinder3D);
    }

    public static String getFrameCylinder3DString(String format, FrameCylinder3DReadOnly cylinder3D) {
        if (cylinder3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getCylinder3DString((String)format, (Cylinder3DReadOnly)cylinder3D) + " - " + cylinder3D.getReferenceFrame();
    }

    public static String getFrameEllipsoid3DString(FrameEllipsoid3DReadOnly ellipsoid3D) {
        return EuclidFrameShapeIOTools.getFrameEllipsoid3DString(EuclidCoreIOTools.DEFAULT_FORMAT, ellipsoid3D);
    }

    public static String getFrameEllipsoid3DString(String format, FrameEllipsoid3DReadOnly ellipsoid3D) {
        if (ellipsoid3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getEllipsoid3DString((String)format, (Ellipsoid3DReadOnly)ellipsoid3D) + " - " + ellipsoid3D.getReferenceFrame();
    }

    public static String getFramePointShape3DString(FramePointShape3DReadOnly pointShape3D) {
        return EuclidFrameShapeIOTools.getFramePointShape3DString(EuclidCoreIOTools.DEFAULT_FORMAT, pointShape3D);
    }

    public static String getFramePointShape3DString(String format, FramePointShape3DReadOnly pointShape3D) {
        if (pointShape3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getPointShape3DString((String)format, (PointShape3DReadOnly)pointShape3D) + " - " + pointShape3D.getReferenceFrame();
    }

    public static String getFrameRamp3DString(FrameRamp3DReadOnly ramp3D) {
        return EuclidFrameShapeIOTools.getFrameRamp3DString(EuclidCoreIOTools.DEFAULT_FORMAT, ramp3D);
    }

    public static String getFrameRamp3DString(String format, FrameRamp3DReadOnly ramp3D) {
        if (ramp3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getRamp3DString((String)format, (Ramp3DReadOnly)ramp3D) + " - " + ramp3D.getReferenceFrame();
    }

    public static String getFrameSphere3DString(FrameSphere3DReadOnly sphere3D) {
        return EuclidFrameShapeIOTools.getFrameSphere3DString(EuclidCoreIOTools.DEFAULT_FORMAT, sphere3D);
    }

    public static String getFrameSphere3DString(String format, FrameSphere3DReadOnly sphere3D) {
        if (sphere3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getSphere3DString((String)format, (Sphere3DReadOnly)sphere3D) + " - " + sphere3D.getReferenceFrame();
    }

    public static String getFrameTorus3DString(FrameTorus3DReadOnly torus3D) {
        return EuclidFrameShapeIOTools.getFrameTorus3DString(EuclidCoreIOTools.DEFAULT_FORMAT, torus3D);
    }

    public static String getFrameTorus3DString(String format, FrameTorus3DReadOnly torus3D) {
        if (torus3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getTorus3DString((String)format, (Torus3DReadOnly)torus3D) + " - " + torus3D.getReferenceFrame();
    }

    public static String getFrameShape3DPoseString(FrameShape3DPoseReadOnly shape3DPose) {
        return EuclidFrameShapeIOTools.getFrameShape3DPoseString(EuclidCoreIOTools.DEFAULT_FORMAT, shape3DPose);
    }

    public static String getFrameShape3DPoseString(String format, FrameShape3DPoseReadOnly shape3DPose) {
        if (shape3DPose == null) {
            return "null";
        }
        return EuclidShapeIOTools.getShape3DPoseString((String)format, (Shape3DPoseReadOnly)shape3DPose) + " - " + shape3DPose.getReferenceFrame();
    }

    public static String getEuclidFrameShape3DCollisionResultString(EuclidFrameShape3DCollisionResultReadOnly euclidShape3DCollisionResult) {
        return EuclidFrameShapeIOTools.getEuclidFrameShape3DCollisionResultString(EuclidCoreIOTools.DEFAULT_FORMAT, euclidShape3DCollisionResult);
    }

    public static String getEuclidFrameShape3DCollisionResultString(String format, EuclidFrameShape3DCollisionResultReadOnly euclidShape3DCollisionResult) {
        if (euclidShape3DCollisionResult == null) {
            return "null";
        }
        String string = "Collision test result: ";
        string = euclidShape3DCollisionResult.areShapesColliding() ? string + "colliding, depth: " + euclidShape3DCollisionResult.getSignedDistance() + "\n" : string + "non-colliding, separating distance: " + euclidShape3DCollisionResult.getSignedDistance() + "\n";
        FrameShape3DReadOnly shapeA = euclidShape3DCollisionResult.getShapeA();
        FrameShape3DReadOnly shapeB = euclidShape3DCollisionResult.getShapeB();
        string = string + "Shape A: " + (shapeA == null ? "null" : shapeA.getClass().getSimpleName() + " - " + shapeA.getReferenceFrame().getName());
        string = string + ", location: " + EuclidFrameIOTools.getFrameTuple3DString((String)format, (FrameTuple3DReadOnly)euclidShape3DCollisionResult.getPointOnA());
        string = string + ", normal: " + EuclidFrameIOTools.getFrameTuple3DString((String)format, (FrameTuple3DReadOnly)euclidShape3DCollisionResult.getNormalOnA()) + "\n";
        string = string + "Shape B: " + (shapeB == null ? "null" : shapeB.getClass().getSimpleName() + " - " + shapeB.getReferenceFrame().getName());
        string = string + ", location: " + EuclidFrameIOTools.getFrameTuple3DString((String)format, (FrameTuple3DReadOnly)euclidShape3DCollisionResult.getPointOnB());
        string = string + ", normal: " + EuclidFrameIOTools.getFrameTuple3DString((String)format, (FrameTuple3DReadOnly)euclidShape3DCollisionResult.getNormalOnB());
        return string;
    }

    public static String getFrameVertex3DString(FrameVertex3DReadOnly vertex3D) {
        return EuclidFrameShapeIOTools.getFrameVertex3DString(EuclidCoreIOTools.DEFAULT_FORMAT, vertex3D);
    }

    public static String getFrameVertex3DString(String format, FrameVertex3DReadOnly vertex3D) {
        if (vertex3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getVertex3DString((String)format, (Vertex3DReadOnly)vertex3D) + "\n\t" + vertex3D.getReferenceFrame();
    }

    public static String getFrameHalfEdge3DString(FrameHalfEdge3DReadOnly halfEdge3D) {
        return EuclidFrameShapeIOTools.getFrameHalfEdge3DString(EuclidCoreIOTools.DEFAULT_FORMAT, halfEdge3D);
    }

    public static String getFrameHalfEdge3DString(String format, FrameHalfEdge3DReadOnly halfEdge3D) {
        if (halfEdge3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getHalfEdge3DString((String)format, (HalfEdge3DReadOnly)halfEdge3D) + "\n\t" + halfEdge3D.getReferenceFrame();
    }

    public static String getFrameFace3DString(FrameFace3DReadOnly face3D) {
        return EuclidFrameShapeIOTools.getFrameFace3DString(EuclidCoreIOTools.DEFAULT_FORMAT, face3D);
    }

    public static String getFrameFace3DString(String format, FrameFace3DReadOnly face3D) {
        if (face3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getFace3DString((String)format, (Face3DReadOnly)face3D) + "\n\t" + face3D.getReferenceFrame();
    }

    public static String getFrameConvexPolytope3DString(FrameConvexPolytope3DReadOnly convexPolytope3D) {
        return EuclidFrameShapeIOTools.getFrameConvexPolytope3DString(EuclidCoreIOTools.DEFAULT_FORMAT, convexPolytope3D);
    }

    public static String getFrameConvexPolytope3DString(String format, FrameConvexPolytope3DReadOnly convexPolytope3D) {
        if (convexPolytope3D == null) {
            return "null";
        }
        return EuclidShapeIOTools.getConvexPolytope3DString((String)format, (ConvexPolytope3DReadOnly)convexPolytope3D) + "\n" + convexPolytope3D.getReferenceFrame();
    }
}

