/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FixedFrameShape3DPose;
import us.ihmc.euclid.referenceFrame.FrameBoxPolytope3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoxPolytope3DView;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameBox3D
implements FrameBox3DBasics,
GeometryObject<FrameBox3D> {
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private ReferenceFrame referenceFrame;
    private final FixedFrameShape3DPose pose = new FixedFrameShape3DPose(this);
    private IntermediateVariableSupplier supplier = IntermediateVariableSupplier.defaultIntermediateVariableSupplier();
    private final FixedFrameVector3DBasics size = EuclidFrameFactories.newObservableFixedFrameVector3DBasics((ReferenceFrameHolder)this, (axis, newValue) -> {
        this.checkSizePositive((Axis3D)axis);
        this.notifyChangeListeners();
    }, null);
    private FrameBoxPolytope3D polytopeView = null;

    public FrameBox3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameBox3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 1.0, 1.0);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, double sizeX, double sizeY, double sizeZ) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set(sizeX, sizeY, sizeZ);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, Vector3DReadOnly size) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set((Tuple3DReadOnly)size);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, position, orientation, sizeX, sizeY, sizeZ);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, position, orientation, size);
    }

    public FrameBox3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(position, orientation, sizeX, sizeY, sizeZ);
    }

    public FrameBox3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
    }

    public FrameBox3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
    }

    public FrameBox3D(FramePose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
    }

    public FrameBox3D(FramePose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
    }

    public FrameBox3D(FramePose3DReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
    }

    public FrameBox3D(FrameShape3DPoseReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
    }

    public FrameBox3D(FrameShape3DPoseReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
    }

    public FrameBox3D(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
    }

    public FrameBox3D(ReferenceFrame referenceFrame, Box3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    public FrameBox3D(FrameBox3DReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFrameShape3DPoseBasics getPose() {
        return this.pose;
    }

    @Override
    public FixedFrameVector3DBasics getSize() {
        return this.size;
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.supplier;
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.supplier = newSupplier;
    }

    public void set(FrameBox3D other) {
        FrameBox3DBasics.super.set(other);
    }

    @Override
    public FrameBox3D copy() {
        return new FrameBox3D(this);
    }

    @Override
    public FrameBoxPolytope3DView asConvexPolytope() {
        if (this.polytopeView == null) {
            this.polytopeView = new FrameBoxPolytope3D(this);
        }
        return this.polytopeView;
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
        this.pose.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        boolean hasBeenRemoved = this.changeListeners.remove(listener);
        return hasBeenRemoved |= this.pose.removeChangeListener(listener);
    }

    public boolean epsilonEquals(FrameBox3D other, double epsilon) {
        return FrameBox3DBasics.super.epsilonEquals((FrameBox3DReadOnly)other, epsilon);
    }

    public boolean geometricallyEquals(FrameBox3D other, double epsilon) {
        return FrameBox3DBasics.super.geometricallyEquals((FrameBox3DReadOnly)other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameBox3DReadOnly) {
            return FrameBox3DBasics.super.equals((FrameBox3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.pose, (Object)this.size);
    }

    public String toString() {
        return EuclidFrameShapeIOTools.getFrameBox3DString(this);
    }
}

