/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision.interfaces;

import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;

public interface EuclidFrameShape3DCollisionResultReadOnly
extends EuclidShape3DCollisionResultReadOnly {
    public FramePoint3DReadOnly getPointOnA();

    public FramePoint3DReadOnly getPointOnB();

    public FrameVector3DReadOnly getNormalOnA();

    public FrameVector3DReadOnly getNormalOnB();

    public FrameShape3DReadOnly getShapeA();

    public FrameShape3DReadOnly getShapeB();

    default public boolean epsilonEquals(EuclidFrameShape3DCollisionResultReadOnly other, double epsilon) {
        if (this.getPointOnA().getReferenceFrame() != other.getPointOnA().getReferenceFrame()) {
            return false;
        }
        if (this.getPointOnB().getReferenceFrame() != other.getPointOnB().getReferenceFrame()) {
            return false;
        }
        if (this.getNormalOnA().getReferenceFrame() != other.getNormalOnA().getReferenceFrame()) {
            return false;
        }
        if (this.getNormalOnB().getReferenceFrame() != other.getNormalOnB().getReferenceFrame()) {
            return false;
        }
        return super.epsilonEquals((EuclidShape3DCollisionResultReadOnly)other, epsilon);
    }

    default public boolean geometricallyEquals(EuclidFrameShape3DCollisionResultReadOnly other, double epsilon) {
        return this.geometricallyEquals(other, epsilon, epsilon, epsilon);
    }

    default public boolean geometricallyEquals(EuclidFrameShape3DCollisionResultReadOnly other, double distanceEpsilon, double pointTangentialEpsilon, double normalEpsilon) {
        boolean swap = this.getShapeA() != null || this.getShapeB() != null || other.getShapeA() != null || other.getShapeB() != null ? this.getShapeA() != other.getShapeA() : this.getPointOnA().getReferenceFrame() != other.getPointOnA().getReferenceFrame();
        FramePoint3DReadOnly otherPointOnA = swap ? other.getPointOnB() : other.getPointOnA();
        FramePoint3DReadOnly otherPointOnB = swap ? other.getPointOnA() : other.getPointOnB();
        FrameVector3DReadOnly otherNormalOnA = swap ? other.getNormalOnB() : other.getNormalOnA();
        FrameVector3DReadOnly otherNormalOnB = swap ? other.getNormalOnA() : other.getNormalOnB();
        this.getPointOnA().checkReferenceFrameMatch((ReferenceFrameHolder)otherPointOnA);
        this.getPointOnB().checkReferenceFrameMatch((ReferenceFrameHolder)otherPointOnB);
        this.getNormalOnA().checkReferenceFrameMatch((ReferenceFrameHolder)otherNormalOnA);
        this.getNormalOnB().checkReferenceFrameMatch((ReferenceFrameHolder)otherNormalOnB);
        return super.geometricallyEquals((EuclidShape3DCollisionResultReadOnly)other, distanceEpsilon, pointTangentialEpsilon, normalEpsilon);
    }

    default public boolean equals(EuclidFrameShape3DCollisionResultReadOnly other) {
        if (other == null) {
            return false;
        }
        if (this.getPointOnA().getReferenceFrame() != other.getPointOnA().getReferenceFrame()) {
            return false;
        }
        if (this.getPointOnB().getReferenceFrame() != other.getPointOnB().getReferenceFrame()) {
            return false;
        }
        if (this.getNormalOnA().getReferenceFrame() != other.getNormalOnA().getReferenceFrame()) {
            return false;
        }
        if (this.getNormalOnB().getReferenceFrame() != other.getNormalOnB().getReferenceFrame()) {
            return false;
        }
        return super.equals((EuclidShape3DCollisionResultReadOnly)other);
    }
}

