/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.utils;

import java.util.ArrayList;
import java.util.List;
import us.codecraft.webmagic.model.annotation.ExtractBy;
import us.codecraft.webmagic.selector.CssSelector;
import us.codecraft.webmagic.selector.RegexSelector;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.XpathSelector;

public class ExtractorUtils {
    public static Selector getSelector(ExtractBy extractBy) {
        CssSelector selector;
        String value = extractBy.value();
        switch (extractBy.type()) {
            case Css: {
                selector = new CssSelector(value);
                break;
            }
            case Regex: {
                selector = new RegexSelector(value);
                break;
            }
            case XPath: {
                selector = new XpathSelector(value);
                break;
            }
            default: {
                selector = new XpathSelector(value);
            }
        }
        return selector;
    }

    public static List<Selector> getSelectors(ExtractBy[] extractBies) {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        if (extractBies == null) {
            return selectors;
        }
        for (ExtractBy extractBy : extractBies) {
            selectors.add(ExtractorUtils.getSelector(extractBy));
        }
        return selectors;
    }
}

