/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.processor.SimplePageProcessor;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.utils.Experimental;
import us.codecraft.webmagic.utils.FilePersistentBase;
import us.codecraft.webmagic.utils.UrlUtils;

@Experimental
public class FileCache
extends FilePersistentBase
implements Downloader,
Pipeline,
PageProcessor {
    private Downloader downloaderWhenFileMiss;
    private final PageProcessor pageProcessor;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public FileCache(String startUrl, String urlPattern) {
        this(startUrl, urlPattern, "/data/webmagic/temp/");
    }

    public FileCache(String startUrl, String urlPattern, String path) {
        this.pageProcessor = new SimplePageProcessor(startUrl, urlPattern);
        this.setPath(path);
        this.downloaderWhenFileMiss = new HttpClientDownloader();
    }

    public FileCache setDownloaderWhenFileMiss(Downloader downloaderWhenFileMiss) {
        this.downloaderWhenFileMiss = downloaderWhenFileMiss;
        return this;
    }

    public Page download(Request request, Task task) {
        String path = this.path + "/" + task.getUUID() + "/";
        Page page = null;
        try {
            File file = this.getFile(path + DigestUtils.md5Hex((String)request.getUrl()));
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String line = bufferedReader.readLine();
            if (line.equals("url:\t" + request.getUrl())) {
                String html = this.getHtml(bufferedReader);
                page = new Page();
                page.setRequest(request);
                page.setUrl((Selectable)PlainText.create((String)request.getUrl()));
                page.setHtml((Selectable)Html.create((String)UrlUtils.fixAllRelativeHrefs((String)html, (String)request.getUrl())));
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                this.logger.info((Object)("File not exist for url " + request.getUrl()));
            }
            this.logger.warn((Object)("File read error for url " + request.getUrl()), (Throwable)e);
        }
        if (page == null) {
            page = this.downloadWhenMiss(request, task);
        }
        return page;
    }

    public void setThread(int thread) {
    }

    private String getHtml(BufferedReader bufferedReader) throws IOException {
        StringBuilder htmlBuilder = new StringBuilder();
        String line = bufferedReader.readLine();
        line = StringUtils.removeStart((String)line, (String)"html:\t");
        htmlBuilder.append(line);
        while ((line = bufferedReader.readLine()) != null) {
            htmlBuilder.append(line);
        }
        return htmlBuilder.toString();
    }

    private Page downloadWhenMiss(Request request, Task task) {
        Page page = null;
        if (this.downloaderWhenFileMiss != null) {
            page = this.downloaderWhenFileMiss.download(request, task);
        }
        return page;
    }

    public void process(ResultItems resultItems, Task task) {
        String path = this.path + PATH_SEPERATOR + task.getUUID() + PATH_SEPERATOR;
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.getFile(path + DigestUtils.md5Hex((String)resultItems.getRequest().getUrl()) + ".html")));
            printWriter.println("url:\t" + resultItems.getRequest().getUrl());
            printWriter.println("html:\t" + resultItems.get("html"));
            printWriter.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"write file error", (Throwable)e);
        }
    }

    public void process(Page page) {
        this.pageProcessor.process(page);
    }

    public Site getSite() {
        return this.pageProcessor.getSite();
    }
}

