/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.model.PageMapper;
import us.codecraft.webmagic.proxy.ProxyProvider;

public class SimpleHttpClient {
    private final HttpClientDownloader httpClientDownloader;
    private final Site site;

    public SimpleHttpClient() {
        this(Site.me());
    }

    public SimpleHttpClient(Site site) {
        this.site = site;
        this.httpClientDownloader = new HttpClientDownloader();
    }

    public void setProxyProvider(ProxyProvider proxyProvider) {
        this.httpClientDownloader.setProxyProvider(proxyProvider);
    }

    public <T> T get(String url, Class<T> clazz) {
        return this.get(new Request(url), clazz);
    }

    public <T> T get(Request request, Class<T> clazz) {
        Page page = this.httpClientDownloader.download(request, this.site.toTask());
        if (!page.isDownloadSuccess()) {
            return null;
        }
        return new PageMapper<T>(clazz).get(page);
    }

    public Page get(String url) {
        return this.httpClientDownloader.download(new Request(url), this.site.toTask());
    }

    public Page get(Request request) {
        return this.httpClientDownloader.download(request, this.site.toTask());
    }
}

