/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.pipeline;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.annotation.ThreadSafe;
import org.apache.log4j.Logger;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.utils.FilePersistentBase;

@ThreadSafe
public class FilePipeline
extends FilePersistentBase
implements Pipeline {
    private Logger logger = Logger.getLogger(this.getClass());

    public FilePipeline() {
        this.setPath("/data/webmagic/");
    }

    public FilePipeline(String path) {
        this.setPath(path);
    }

    @Override
    public void process(ResultItems resultItems, Task task) {
        String path = this.path + PATH_SEPERATOR + task.getUUID() + PATH_SEPERATOR;
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.getFile(path + DigestUtils.md5Hex((String)resultItems.getRequest().getUrl()) + ".html")));
            printWriter.println("url:\t" + resultItems.getRequest().getUrl());
            for (Map.Entry<String, Object> entry : resultItems.getAll().entrySet()) {
                if (entry.getValue() instanceof Iterable) {
                    Iterable value = (Iterable)entry.getValue();
                    printWriter.println(entry.getKey() + ":");
                    for (Object o : value) {
                        printWriter.println(o);
                    }
                    continue;
                }
                printWriter.println(entry.getKey() + ":\t" + entry.getValue());
            }
            printWriter.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"write file error", (Throwable)e);
        }
    }
}

