/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import us.codecraft.webmagic.selector.Selector;

public class ReplaceSelector
implements Selector {
    private String regexStr;
    private String replacement;
    private Pattern regex;

    public ReplaceSelector(String regexStr, String replacement) {
        this.regexStr = regexStr;
        this.replacement = replacement;
        try {
            this.regex = Pattern.compile(regexStr);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("invalid regex", e);
        }
    }

    @Override
    public String select(String text) {
        Matcher matcher = this.regex.matcher(text);
        return matcher.replaceAll(this.replacement);
    }

    @Override
    public List<String> selectList(String text) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.regexStr + "_" + this.replacement;
    }
}

