/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPConstants;
import org.apache.jmeter.protocol.http.util.HTTPConstantsInterface;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import us.abstracta.jmeter.javadsl.JmeterDsl;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.preprocessors.DslJsr223PreProcessor;
import us.abstracta.jmeter.javadsl.core.util.JmeterFunction;
import us.abstracta.jmeter.javadsl.http.ClientImplParam;
import us.abstracta.jmeter.javadsl.http.ContentTypeParam;
import us.abstracta.jmeter.javadsl.http.DslBaseHttpSampler;
import us.abstracta.jmeter.javadsl.http.EncodingParam;

public class DslHttpSampler
extends DslBaseHttpSampler<DslHttpSampler> {
    private static final String DEFAULT_NAME = "HTTP Request";
    private String method = "GET";
    private final List<HTTPArgument> arguments = new ArrayList<HTTPArgument>();
    private String body;
    private boolean multiPart;
    private final List<HTTPFileArg> files = new ArrayList<HTTPFileArg>();
    private Charset encoding;
    private boolean followRedirects = true;
    private boolean downloadEmbeddedResources;
    private HttpClientImpl clientImpl;

    public DslHttpSampler(String name, String url) {
        super(name != null ? name : DEFAULT_NAME, url, HttpTestSampleGui.class);
    }

    public DslHttpSampler(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> urlSupplier) {
        this(name, (String)null);
        String variableName = "PRE_PROCESSOR_URL";
        this.path = JmeterFunction.var(variableName);
        this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)urlSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler post(String body, ContentType contentType) {
        return ((DslHttpSampler)this.method("POST").contentType(contentType)).body(body);
    }

    public DslHttpSampler post(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier, ContentType contentType) {
        return ((DslHttpSampler)this.method("POST").contentType(contentType)).body(bodySupplier);
    }

    public DslHttpSampler method(String method) {
        this.method = method;
        return this;
    }

    public DslHttpSampler body(String body) {
        this.body = body;
        return this;
    }

    public DslHttpSampler body(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier) {
        String variableName = "PRE_PROCESSOR_REQUEST_BODY";
        this.body = JmeterFunction.var(variableName);
        return (DslHttpSampler)this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)bodySupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler bodyFile(String filePath) {
        this.files.add(new HTTPFileArg(filePath, "", ""));
        return this;
    }

    public DslHttpSampler param(String name, String value) {
        this.arguments.add(new HTTPArgument(name, value));
        return this;
    }

    public DslHttpSampler encodedParam(String name, String value) {
        return this.rawParam(name, value);
    }

    public DslHttpSampler rawParam(String name, String value) {
        HTTPArgument arg = new HTTPArgument(name, value);
        arg.setAlwaysEncoded(false);
        this.arguments.add(arg);
        return this;
    }

    public DslHttpSampler bodyPart(String name, String value, ContentType contentType) {
        this.multiPart = true;
        HTTPArgument arg = new HTTPArgument(name, value);
        arg.setContentType(contentType.toString());
        this.arguments.add(arg);
        return this;
    }

    public DslHttpSampler bodyFilePart(String name, String filePath, ContentType contentType) {
        this.multiPart = true;
        this.files.add(new HTTPFileArg(filePath, name, contentType.toString()));
        return this;
    }

    public DslHttpSampler encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslHttpSampler followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public DslHttpSampler downloadEmbeddedResources() {
        this.downloadEmbeddedResources = true;
        return this;
    }

    public DslHttpSampler clientImpl(HttpClientImpl clientImpl) {
        this.clientImpl = clientImpl;
        return this;
    }

    @Override
    public HTTPSamplerProxy configureHttpTestElement(HTTPSamplerProxy elem) {
        elem.setMethod(this.method);
        elem.setArguments(this.buildArguments());
        if (this.multiPart) {
            elem.setDoMultipart(true);
        }
        elem.setHTTPFiles(this.files.toArray(new HTTPFileArg[0]));
        if (this.encoding != null) {
            elem.setContentEncoding(this.encoding.toString());
        }
        elem.setFollowRedirects(this.followRedirects);
        elem.setUseKeepAlive(true);
        if (this.downloadEmbeddedResources) {
            elem.setImageParser(true);
            elem.setConcurrentDwn(true);
        }
        if (this.clientImpl != null) {
            elem.setImplementation(this.clientImpl.propertyValue);
        }
        return elem;
    }

    private Arguments buildArguments() {
        Arguments args = new Arguments();
        if (this.body != null) {
            HTTPArgument arg = new HTTPArgument("", this.body, false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        }
        this.arguments.forEach(arg_0 -> ((Arguments)args).addArgument(arg_0));
        return args;
    }

    public static class CodeBuilder
    extends DslBaseHttpSampler.BaseHttpSamplerCodeBuilder {
        public CodeBuilder(List<Method> builderMethods) {
            super(DslHttpSampler.DEFAULT_NAME, HttpTestSampleGui.class, builderMethods);
        }

        @Override
        protected MethodCall buildBaseHttpMethodCall(MethodParam name, MethodParam url, TestElementParamBuilder paramBuilder) {
            return this.buildMethodCall(name, url);
        }

        @Override
        protected void setAdditionalOptions(MethodCall ret, TestElementParamBuilder paramBuilder) {
            ret.chain("encoding", EncodingParam.from(paramBuilder)).chain("followRedirects", this.buildFollowRedirectsParam(paramBuilder)).chain("downloadEmbeddedResources", paramBuilder.boolParam("HTTPSampler.image_parser", false)).chain("clientImpl", ClientImplParam.from(paramBuilder));
        }

        @Override
        protected void buildRequestCall(MethodCall ret, HTTPSamplerProxy testElem, MethodCallContext buildContext) {
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElem);
            MethodParam method = HttpMethodParam.from(paramBuilder);
            MethodCallContext headers = buildContext.removeChild(HeaderManager.class);
            String contentType = this.removeContentTypeHeader(headers);
            Arguments args = testElem.getArguments();
            if (method instanceof MethodParam.StringParam && !method.isDefault() && "POST".equals(((String)((MethodParam.StringParam)method).getValue()).toUpperCase(Locale.US)) && !testElem.getUseMultipart() && contentType != null && this.isRawBody(args)) {
                ret.chain("post", this.buildRawBody(args), new ContentTypeParam(contentType));
                this.chainHeaders(ret, headers);
                return;
            }
            ret.chain("method", method);
            if (contentType != null) {
                this.chainContentType(ret, contentType);
            }
            this.chainHeaders(ret, headers);
            if (this.isRawBody(args)) {
                ret.chain("body", this.buildRawBody(args));
            } else if (testElem.getSendFileAsPostBody()) {
                HTTPFileArg file = testElem.getHTTPFiles()[0];
                if (file.getMimeType() != null && !file.getMimeType().isEmpty()) {
                    this.chainContentType(ret, file.getMimeType());
                }
                ret.chain("bodyFile", new MethodParam.StringParam(file.getPath()));
            } else if (testElem.getUseMultipart()) {
                for (JMeterProperty prop : args) {
                    HTTPArgument arg = (HTTPArgument)prop.getObjectValue();
                    ret.chain("bodyPart", new MethodParam.StringParam(arg.getName()), new MethodParam.StringParam(arg.getValue()), new ContentTypeParam(arg.getContentType()));
                }
                for (HTTPFileArg file : testElem.getHTTPFiles()) {
                    ret.chain("bodyFilePart", new MethodParam.StringParam(file.getParamName()), new MethodParam.StringParam(file.getPath()), new ContentTypeParam(file.getMimeType()));
                }
            } else {
                for (JMeterProperty prop : args) {
                    HTTPArgument arg = (HTTPArgument)prop.getObjectValue();
                    if (arg.isAlwaysEncoded()) {
                        ret.chain("param", new MethodParam.StringParam(arg.getName()), new MethodParam.StringParam(arg.getValue()));
                        continue;
                    }
                    ret.chain("rawParam", new MethodParam.StringParam(arg.getName()), new MethodParam.StringParam(arg.getValue()));
                }
            }
        }

        private boolean isRawBody(Arguments args) {
            return args.getArgumentCount() == 1 && args.getArgument(0).getName().isEmpty();
        }

        private MethodParam.StringParam buildRawBody(Arguments args) {
            return new MethodParam.StringParam(args.getArgument(0).getValue());
        }

        private MethodParam buildFollowRedirectsParam(TestElementParamBuilder paramBuilder) {
            MethodParam follow = paramBuilder.boolParam("HTTPSampler.follow_redirects", true);
            if (!follow.isDefault()) {
                return follow;
            }
            MethodParam auto = paramBuilder.boolParam("HTTPSampler.auto_redirects", false);
            return auto instanceof MethodParam.BoolParam && Boolean.TRUE.equals(((MethodParam.BoolParam)auto).getValue()) ? new MethodParam.BoolParam(true, (Boolean)true) : follow;
        }

        private static class HttpMethodParam
        extends MethodParam.StringParam {
            private static final Map<String, String> CONSTANT_METHODS = HttpMethodParam.findConstantNames(HTTPConstantsInterface.class, String.class, f -> {
                try {
                    String value = (String)f.get(null);
                    return !"HTTP/1.1".equals(value) && value.equals(value.toUpperCase(Locale.US));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });

            private HttpMethodParam(String expression, String defaultValue) {
                super(expression, defaultValue);
            }

            public static MethodParam from(TestElementParamBuilder paramBuilder) {
                return paramBuilder.buildParam("HTTPSampler.method", HttpMethodParam::new, "GET");
            }

            @Override
            public boolean isDefault() {
                return super.isDefault() || this.value != null && this.defaultValue != null && ((String)this.defaultValue).equals(((String)this.value).toUpperCase(Locale.US));
            }

            @Override
            public String buildCode(String indent) {
                String constant = CONSTANT_METHODS.get(this.value != null ? ((String)this.value).toUpperCase(Locale.US) : null);
                return constant != null ? HTTPConstants.class.getSimpleName() + "." + constant : super.buildCode(indent);
            }
        }
    }

    public static enum HttpClientImpl {
        JAVA("Java"),
        HTTP_CLIENT("HttpClient4");

        private static final Map<String, HttpClientImpl> IMPLS_BY_PROPERTY_VALUE;
        public final String propertyValue;

        private HttpClientImpl(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public static HttpClientImpl fromPropertyValue(String propertyValue) {
            if (propertyValue.isEmpty()) {
                return null;
            }
            HttpClientImpl ret = IMPLS_BY_PROPERTY_VALUE.get(propertyValue);
            if (ret == null) {
                throw new IllegalArgumentException("Unknown " + HttpClientImpl.class.getSimpleName() + " property value: " + propertyValue);
            }
            return ret;
        }

        static {
            IMPLS_BY_PROPERTY_VALUE = Arrays.stream(HttpClientImpl.values()).collect(Collectors.toMap(v -> v.propertyValue, v -> v));
        }
    }
}

