/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;

public class MethodCall {
    public static final String INDENT = "  ";
    private static final MethodCall EMPTY_METHOD_CALL = new EmptyMethodCall();
    protected final String methodName;
    private final Class<?> returnType;
    private MethodCall childrenMethod;
    private MethodParam.ChildrenParam<?> childrenParam;
    private final List<MethodParam> params;
    private final List<MethodCall> chain = new ArrayList<MethodCall>();

    protected MethodCall(String methodName, Class<?> returnType, MethodParam ... params) {
        this.methodName = methodName;
        this.returnType = returnType;
        this.params = Arrays.asList(params);
        if (params.length > 0 && params[params.length - 1] instanceof MethodParam.ChildrenParam) {
            this.childrenMethod = this;
            this.childrenParam = (MethodParam.ChildrenParam)params[params.length - 1];
        }
    }

    protected static MethodCall from(Method method, MethodParam ... params) {
        return new MethodCall(method.getName(), method.getReturnType(), params);
    }

    public static MethodCall forStaticMethod(Class<?> methodClass, String methodName, MethodParam ... params) {
        Class[] paramsTypes = (Class[])Arrays.stream(params).map(MethodParam::getType).toArray(Class[]::new);
        Method method = MethodCall.findRequiredStaticMethod(methodClass, methodName, paramsTypes);
        return new MethodCall(methodClass.getSimpleName() + "." + method.getName(), method.getReturnType(), params);
    }

    private static Method findRequiredStaticMethod(Class<?> methodClass, String methodName, Class<?> ... paramsTypes) {
        try {
            Method ret = methodClass.getDeclaredMethod(methodName, paramsTypes);
            if (!Modifier.isPublic(ret.getModifiers()) || !Modifier.isStatic(ret.getModifiers())) {
                throw new RuntimeException("Can't access method " + ret + " which is no longer static or public. Check that no dependencies or APIs have been changed.");
            }
            return ret;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't find method " + methodClass.getName() + "." + methodName + " for parameter types " + Arrays.toString(paramsTypes) + ". Check that no dependencies or APIs have been changed.", e);
        }
    }

    public static MethodCall buildUnsupported() {
        return new MethodCall("unsupported", UnsupportedTestElement.class, new MethodParam[0]);
    }

    public static MethodCall emptyCall() {
        return EMPTY_METHOD_CALL;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public MethodCall child(MethodCall child) {
        if (this.childrenMethod == null) {
            this.childrenMethod = this.findChildrenMethod();
            this.chain.add(this.childrenMethod);
            this.childrenParam = (MethodParam.ChildrenParam)this.childrenMethod.params.get(0);
        }
        this.childrenParam.addChild(child);
        return this.childrenMethod;
    }

    private MethodCall findChildrenMethod() {
        Method childrenMethod = null;
        for (Class<?> methodHolder = this.returnType; childrenMethod == null && methodHolder != Object.class; methodHolder = methodHolder.getSuperclass()) {
            childrenMethod = Arrays.stream(methodHolder.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && "children".equals(m.getName()) && m.getParameterCount() == 1).findAny().orElse(null);
        }
        if (childrenMethod == null) {
            throw new IllegalStateException("No children method found for " + this.returnType + ". This might be due to unexpected test plan structure or missing method in test element. Please create an issue in GitHub repository if you find any of these cases.");
        }
        return new ChildrenMethodCall(childrenMethod);
    }

    public MethodCall chain(String methodName, MethodParam ... params) {
        if (params.length == 1 && params[0].isDefault()) {
            return this;
        }
        Method method = this.findMethodInClassHierarchyMatchingParams(methodName, this.returnType, params);
        if (method == null && params.length == 1 && params[0] instanceof MethodParam.BoolParam && (method = this.findMethodInClassHierarchyMatchingParams(methodName, this.returnType, new MethodParam[0])) != null) {
            params = new MethodParam[]{};
        }
        if (method == null) {
            throw MethodCall.buildNoMatchingMethodFoundException("public '" + methodName + "' method in " + this.returnType.getName(), params);
        }
        this.chain.add(MethodCall.from(method, params));
        return this;
    }

    private Method findMethodInClassHierarchyMatchingParams(String methodName, Class<?> methodClass, MethodParam[] params) {
        Method ret = null;
        while (ret == null && methodClass != Object.class) {
            ret = this.findMethodInClassMatchingParams(methodName, methodClass, params);
            methodClass = methodClass.getSuperclass();
        }
        return ret;
    }

    private Method findMethodInClassMatchingParams(String methodName, Class<?> methodClass, MethodParam[] params) {
        Stream<Method> chainableMethods = Arrays.stream(methodClass.getDeclaredMethods()).filter(m -> methodName.equals(m.getName()) && Modifier.isPublic(m.getModifiers()) && m.getReturnType().isAssignableFrom(methodClass));
        return MethodCall.findParamsMatchingMethod(chainableMethods, params);
    }

    protected static Method findParamsMatchingMethod(Stream<Method> methods, MethodParam[] params) {
        List finalParams = Arrays.stream(params).filter(p -> !p.isIgnored()).collect(Collectors.toList());
        return methods.filter(m -> MethodCall.methodMatchesParameters(m, finalParams)).findAny().orElse(null);
    }

    private static boolean methodMatchesParameters(Method m, List<MethodParam> params) {
        if (m.getParameterCount() != params.size()) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i).getType().isAssignableFrom(paramTypes[i])) continue;
            return false;
        }
        return true;
    }

    protected static UnsupportedOperationException buildNoMatchingMethodFoundException(String methodCondition, MethodParam[] params) {
        return new UnsupportedOperationException("No " + methodCondition + " method was found for parameters " + Arrays.toString(params) + ". This is probably due to some change in DSL not reflected in associated code builder.");
    }

    public void reChain(MethodCall other) {
        this.chain.addAll(other.chain);
    }

    public String buildCode() {
        return this.buildCode("");
    }

    protected String buildCode(String indent) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.methodName).append("(");
        String childIndent = indent + INDENT;
        String paramsCode = this.buildParamsCode(childIndent);
        ret.append(this.reIndentParenthesis(paramsCode));
        boolean hasChildren = paramsCode.endsWith("\n");
        if (hasChildren) {
            ret.append(indent);
        }
        ret.append(")");
        String chainedCode = this.buildChainedCode(childIndent);
        if (!chainedCode.isEmpty()) {
            if (!hasChildren) {
                ret.append("\n").append(childIndent);
            }
            ret.append(".");
            ret.append(chainedCode);
        }
        return ret.toString();
    }

    private String reIndentParenthesis(String paramsCode) {
        String indentedParenthesis = "  )";
        return paramsCode.endsWith(indentedParenthesis) ? paramsCode.substring(0, paramsCode.length() - indentedParenthesis.length()) + ")" : paramsCode;
    }

    protected String buildParamsCode(String indent) {
        String ret = this.params.stream().filter(p -> !p.isIgnored()).map(p -> p.buildCode(indent)).filter(s -> !s.isEmpty()).collect(Collectors.joining(", "));
        return ret.replace(", \n", ",\n").replaceAll("\n\\s*\n", "\n");
    }

    private String buildChainedCode(String indent) {
        return this.chain.stream().map(c -> c.buildCode(indent)).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n" + indent + "."));
    }

    private static class ChildrenMethodCall
    extends MethodCall {
        protected ChildrenMethodCall(Method method) {
            super(method.getName(), method.getReturnType(), new MethodParam.ChildrenParam(method.getParameterTypes()[0]));
        }

        @Override
        protected String buildCode(String indent) {
            String paramsCode = this.buildParamsCode(indent + MethodCall.INDENT);
            return paramsCode.isEmpty() ? "" : this.methodName + "(" + paramsCode + indent + ")";
        }
    }

    private static class EmptyMethodCall
    extends MethodCall {
        protected EmptyMethodCall() {
            super(null, MultiLevelTestElement.class, new MethodParam[0]);
        }

        @Override
        public String buildCode(String indent) {
            return "";
        }
    }

    private static class UnsupportedTestElement
    implements MultiLevelTestElement {
        private UnsupportedTestElement() {
        }

        public void children(DslTestElement ... child) {
        }

        @Override
        public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
            return null;
        }

        @Override
        public void showInGui() {
        }
    }
}

