/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.TestElementContainer;
import us.abstracta.jmeter.javadsl.core.threadgroups.DslThreadGroup;

public abstract class BaseThreadGroup<T extends BaseThreadGroup<?>>
extends TestElementContainer<ThreadGroupChild>
implements DslThreadGroup {
    private SampleErrorAction sampleErrorAction = SampleErrorAction.CONTINUE;

    protected BaseThreadGroup(String name, Class<? extends JMeterGUIComponent> guiClass, List<ThreadGroupChild> children) {
        super(name, guiClass, children);
    }

    public T sampleErrorAction(SampleErrorAction sampleErrorAction) {
        this.sampleErrorAction = sampleErrorAction;
        return (T)this;
    }

    public T children(ThreadGroupChild ... children) {
        return (T)((BaseThreadGroup)this.addChildren(children));
    }

    @Override
    protected TestElement buildTestElement() {
        AbstractThreadGroup ret = this.buildThreadGroup();
        ret.setProperty((JMeterProperty)new StringProperty("ThreadGroup.on_sample_error", this.sampleErrorAction.propertyValue));
        return ret;
    }

    protected abstract AbstractThreadGroup buildThreadGroup();

    protected static class SampleErrorActionMethodParam
    extends MethodParam.FixedParam<SampleErrorAction> {
        private SampleErrorActionMethodParam(String expression, SampleErrorAction defaultValue) {
            super(SampleErrorAction.class, expression, SampleErrorAction::fromPropertyValue, defaultValue);
        }

        public static MethodParam from(TestElement testElement) {
            return new TestElementParamBuilder(testElement).buildParam("ThreadGroup.on_sample_error", SampleErrorActionMethodParam::new, SampleErrorAction.CONTINUE);
        }

        @Override
        public String buildCode(String indent) {
            return SampleErrorAction.class.getSimpleName() + "." + ((SampleErrorAction)((Object)this.value)).name();
        }
    }

    public static enum SampleErrorAction {
        CONTINUE("continue"),
        START_NEXT_ITERATION("startnextloop"),
        STOP_THREAD("stopthread"),
        STOP_TEST("stoptest"),
        STOP_TEST_NOW("stoptestnow");

        private static final Map<String, SampleErrorAction> ACTIONS_BY_PROPERTY_VALUE;
        private final String propertyValue;

        private SampleErrorAction(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public static SampleErrorAction fromPropertyValue(String propertyValue) {
            if (propertyValue.isEmpty()) {
                return null;
            }
            SampleErrorAction ret = ACTIONS_BY_PROPERTY_VALUE.get(propertyValue);
            if (ret == null) {
                throw new IllegalArgumentException("Unknown " + SampleErrorAction.class.getSimpleName() + " property value: " + propertyValue);
            }
            return ret;
        }

        static {
            ACTIONS_BY_PROPERTY_VALUE = Arrays.stream(SampleErrorAction.values()).collect(Collectors.toMap(v -> v.propertyValue, v -> v));
        }
    }

    public static interface ThreadGroupChild
    extends DslTestElement {
    }
}

