/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.dashboard.GenerationException;
import org.apache.jmeter.report.dashboard.ReportGenerator;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SimpleDataWriter;
import us.abstracta.jmeter.javadsl.core.listeners.BaseListener;

public class HtmlReporter
extends BaseListener {
    private final File reportDirectory;
    private final ApdexThresholds apdexThresholds = new ApdexThresholds();
    private final Map<String, ApdexThresholds> labelApdexThresholds = new HashMap<String, ApdexThresholds>();

    public HtmlReporter(String reportPath) throws IOException {
        super("Simple Data Writer", SimpleDataWriter.class);
        this.reportDirectory = new File(reportPath);
        if (this.reportDirectory.isFile()) {
            throw new FileAlreadyExistsException(reportPath);
        }
        if (this.reportDirectory.isDirectory() && !this.isEmptyDirectory(this.reportDirectory)) {
            throw new DirectoryNotEmptyException(reportPath);
        }
    }

    private boolean isEmptyDirectory(File reportDirectory) throws IOException {
        try (DirectoryStream<Path> dirContentsStream = Files.newDirectoryStream(reportDirectory.toPath());){
            boolean bl = !dirContentsStream.iterator().hasNext();
            return bl;
        }
    }

    @Override
    public TestElement buildTestElement() {
        if (!this.reportDirectory.exists()) {
            this.reportDirectory.mkdirs();
        }
        File resultsFile = new File(this.reportDirectory, "report.jtl");
        HtmlReportSummariser reporter = new HtmlReportSummariser(resultsFile, this.apdexThresholds, this.labelApdexThresholds);
        AutoFlushingResultCollector logger = new AutoFlushingResultCollector(reporter);
        logger.setFilename(resultsFile.getPath());
        return logger;
    }

    public HtmlReporter apdexThresholds(Duration satisfiedThreshold, Duration toleratedThreshold) {
        this.apdexThresholds.satisfied = satisfiedThreshold;
        this.apdexThresholds.tolerated = toleratedThreshold;
        return this;
    }

    public HtmlReporter transactionApdexThresholds(String sampleLabelRegex, Duration satisfiedThreshold, Duration toleratedThreshold) {
        this.labelApdexThresholds.put(sampleLabelRegex, new ApdexThresholds(satisfiedThreshold, toleratedThreshold));
        return this;
    }

    public static class AutoFlushingResultCollector
    extends ResultCollector {
        public AutoFlushingResultCollector() {
        }

        public AutoFlushingResultCollector(Summariser summer) {
            super(summer);
        }

        public void testEnded(String host) {
            this.flushFile();
            super.testEnded(host);
        }
    }

    private static class HtmlReportSummariser
    extends Summariser {
        private final File resultsFile;
        private final ApdexThresholds apdexThresholds;
        private final Map<String, ApdexThresholds> labelApdexThresholds;
        private final AtomicInteger hostsCount = new AtomicInteger(0);

        private HtmlReportSummariser(File resultsFile, ApdexThresholds apdexThresholds, Map<String, ApdexThresholds> labelApdexThresholds) {
            this.resultsFile = resultsFile;
            this.apdexThresholds = apdexThresholds;
            this.labelApdexThresholds = labelApdexThresholds;
        }

        public void testStarted(String host) {
            super.testStarted(host);
            this.hostsCount.incrementAndGet();
        }

        public void sampleOccurred(SampleEvent e) {
        }

        public void testEnded(String host) {
            if (this.hostsCount.decrementAndGet() <= 0) {
                try {
                    this.configureApdexThresholds();
                    JMeterUtils.setProperty((String)"jmeter.reportgenerator.outputdir", (String)new File(this.resultsFile.getParent()).getAbsolutePath());
                    new ReportGenerator(this.resultsFile.getPath(), null).generate();
                }
                catch (ConfigurationException | GenerationException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void configureApdexThresholds() {
            String transactionsApdex;
            if (this.apdexThresholds.satisfied != null) {
                JMeterUtils.setProperty((String)"jmeter.reportgenerator.apdex_satisfied_threshold", (String)("" + this.apdexThresholds.satisfied.toMillis()));
            }
            if (this.apdexThresholds.tolerated != null) {
                JMeterUtils.setProperty((String)"jmeter.reportgenerator.apdex_tolerated_threshold", (String)("" + this.apdexThresholds.tolerated.toMillis()));
            }
            if (!(transactionsApdex = this.labelApdexThresholds.entrySet().stream().map(e -> (String)e.getKey() + ":" + ((ApdexThresholds)e.getValue()).satisfied.toMillis() + "|" + ((ApdexThresholds)e.getValue()).tolerated.toMillis()).collect(Collectors.joining(";"))).isEmpty()) {
                JMeterUtils.setProperty((String)"jmeter.reportgenerator.apdex_per_transaction", (String)("" + transactionsApdex));
            }
        }
    }

    private static class ApdexThresholds {
        private Duration satisfied;
        private Duration tolerated;

        private ApdexThresholds() {
        }

        private ApdexThresholds(Duration satisfied, Duration tolerated) {
            this.satisfied = satisfied;
            this.tolerated = tolerated;
        }
    }
}

