/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.util;

import java.awt.Color;
import java.util.HashMap;
import javax.swing.BorderFactory;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.GraphPanelChart;
import kg.apc.charting.rows.GraphRowSimple;
import org.apache.jorphan.gui.NumberRenderer;

public class SingleSeriesTimelinePanel
extends GraphPanelChart {
    private final GraphRowSimple series;
    private long curTimeMillis;

    public SingleSeriesTimelinePanel(String seriesName) {
        super(false, true);
        this.getChartSettings().setDrawFinalZeroingLines(true);
        this.setxAxisLabel("Time");
        this.setYAxisLabel(seriesName);
        this.setxAxisLabelRenderer((NumberRenderer)new DateTimeRenderer("HH:mm:ss", 0L));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setForcedMinX(0L);
        HashMap<String, GraphRowSimple> model = new HashMap<String, GraphRowSimple>();
        this.series = this.buildSeries();
        model.put(seriesName, this.series);
        this.setRows(model);
    }

    private GraphRowSimple buildSeries() {
        GraphRowSimple ret = new GraphRowSimple();
        ret.setColor(Color.RED);
        ret.setDrawLine(true);
        ret.setMarkerSize(0);
        return ret;
    }

    public void add(long timeIncrMillis, double val) {
        this.curTimeMillis += timeIncrMillis;
        this.series.add(this.curTimeMillis, val);
    }
}

