/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.codegeneration;

import java.time.Duration;
import java.util.function.BiFunction;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;

public class TestElementParamBuilder {
    private final TestElement testElement;
    private final String propsPrefix;

    public TestElementParamBuilder(TestElement testElement) {
        this(testElement, null);
    }

    public TestElementParamBuilder(TestElement testElement, String propsPrefix) {
        this.testElement = testElement;
        this.propsPrefix = propsPrefix != null ? propsPrefix + "." : "";
    }

    public MethodParam nameParam(String defaultName) {
        return new MethodParam.NameParam(this.testElement.getName(), defaultName);
    }

    public MethodParam intParam(String propName) {
        return this.buildParam(propName, MethodParam.IntParam::new, null);
    }

    public <V, T extends MethodParam> MethodParam buildParam(String propName, BiFunction<String, V, T> builder, V defaultValue) {
        String propVal = this.prop(propName).getStringValue();
        if (propVal != null && MethodParam.DynamicParam.matches(propVal)) {
            return new MethodParam.DynamicParam(propVal);
        }
        try {
            return (MethodParam)builder.apply(propVal, defaultValue);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("DSL does not currently support '%s' as value for %s. If you need this support please open an issue in GitHub repository.", propVal, this.propsPrefix + propName), e);
        }
    }

    public JMeterProperty prop(String propName) {
        propName = this.propsPrefix + propName;
        String[] propLevels = propName.split("/");
        TestElement propHolder = this.testElement;
        for (int i = 0; i < propLevels.length - 1; ++i) {
            propHolder = (TestElement)this.testElement.getProperty(propLevels[i]).getObjectValue();
        }
        return propHolder.getProperty(propLevels[propLevels.length - 1]);
    }

    public MethodParam stringParam(String propName, String defaultValue) {
        return new MethodParam.StringParam(this.prop(propName).getStringValue(), defaultValue);
    }

    public MethodParam stringParam(String propName) {
        return this.stringParam(propName, null);
    }

    public MethodParam boolParam(String propName, boolean defaultValue) {
        return this.buildParam(propName, MethodParam.BoolParam::new, defaultValue);
    }

    public MethodParam durationParam(String propName, Duration defaultValue) {
        return this.buildParam(propName, MethodParam.DurationParam::new, defaultValue);
    }

    public MethodParam durationParam(String propName) {
        return this.durationParam(propName, null);
    }
}

