/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleTestElementCallBuilder;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;
import us.abstracta.jmeter.javadsl.http.ContentTypeParam;

public class HttpHeaders
extends BaseConfigElement {
    private final Map<String, String> headers = new LinkedHashMap<String, String>();

    public HttpHeaders() {
        super("HTTP Header Manager", HeaderPanel.class);
    }

    public HttpHeaders header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpHeaders contentType(ContentType contentType) {
        this.headers.put("Content-Type", contentType.toString());
        return this;
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    protected TestElement buildTestElement() {
        HeaderManager ret = new HeaderManager();
        this.headers.forEach((name, value) -> ret.add(new Header(name, value)));
        return ret;
    }

    public static class CodeBuilder
    extends SingleTestElementCallBuilder<HeaderManager> {
        public CodeBuilder(List<Method> builderMethods) {
            super(HeaderManager.class, builderMethods);
        }

        @Override
        protected MethodCall buildMethodCall(HeaderManager testElement, MethodCallContext context) {
            MethodCall ret = this.buildMethodCall(new MethodParam[0]);
            for (JMeterProperty prop : (CollectionProperty)testElement.getProperty("HeaderManager.headers")) {
                Header header = (Header)prop.getObjectValue();
                if ("Content-Type".equals(header.getName())) {
                    ret.chain("contentType", new ContentTypeParam(header.getValue()));
                    continue;
                }
                ret.chain("header", new MethodParam.StringParam(header.getName()), new MethodParam.StringParam(header.getValue()));
            }
            return ret;
        }
    }
}

