/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.apache.http.entity.ContentType;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.JmeterDsl;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCallContext;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;
import us.abstracta.jmeter.javadsl.codegeneration.SingleGuiClassCallBuilder;
import us.abstracta.jmeter.javadsl.codegeneration.TestElementParamBuilder;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.preprocessors.DslJsr223PreProcessor;
import us.abstracta.jmeter.javadsl.core.samplers.BaseSampler;
import us.abstracta.jmeter.javadsl.http.ContentTypeParam;
import us.abstracta.jmeter.javadsl.http.DslCacheManager;
import us.abstracta.jmeter.javadsl.http.DslCookieManager;
import us.abstracta.jmeter.javadsl.http.HttpHeaders;
import us.abstracta.jmeter.javadsl.http.JmeterUrl;

public abstract class DslBaseHttpSampler<T extends DslBaseHttpSampler<?>>
extends BaseSampler<T> {
    protected String path;
    protected final HttpHeaders headers = new HttpHeaders();
    private String protocol;
    private String host;
    private String port;
    private String proxyUrl;
    private String proxyUser;
    private String proxyPassword;

    public DslBaseHttpSampler(String name, String url, Class<? extends JMeterGUIComponent> guiClass) {
        super(name, guiClass);
        if (url == null) {
            return;
        }
        JmeterUrl parsedUrl = JmeterUrl.valueOf(url);
        this.protocol = parsedUrl.protocol();
        this.host = parsedUrl.host();
        this.port = parsedUrl.port();
        this.path = parsedUrl.path();
    }

    public T protocol(String protocol) {
        this.protocol = protocol;
        return (T)this;
    }

    public T host(String host) {
        this.host = host;
        return (T)this;
    }

    public T port(int port) {
        this.port = String.valueOf(port);
        return (T)this;
    }

    public T header(String name, String value) {
        this.headers.header(name, value);
        return (T)this;
    }

    public T header(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> valueSupplier) {
        String variableNamePrefix = "PRE_PROCESSOR_HEADER~";
        this.headers.header(name, "${" + variableNamePrefix + name + "}");
        return (T)((DslBaseHttpSampler)this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableNamePrefix + name, (String)valueSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s)))));
    }

    public T contentType(ContentType contentType) {
        this.headers.contentType(contentType);
        return (T)this;
    }

    public T proxy(String url) {
        this.proxyUrl = url;
        return (T)this;
    }

    public T proxy(String url, String username, String password) {
        this.proxyUrl = url;
        this.proxyUser = username;
        this.proxyPassword = password;
        return (T)this;
    }

    @Override
    protected TestElement buildTestElement() {
        HTTPSamplerProxy ret = new HTTPSamplerProxy();
        if (this.protocol != null) {
            ret.setProtocol(this.protocol);
        }
        if (this.host != null) {
            ret.setDomain(this.host);
        }
        if (this.port != null) {
            ret.setProperty("HTTPSampler.port", this.port);
        }
        if (this.path != null) {
            ret.setPath(this.path);
        }
        if (this.proxyUrl != null) {
            JmeterUrl parsedUrl = JmeterUrl.valueOf(this.proxyUrl);
            ret.setProxyScheme(parsedUrl.protocol());
            ret.setProxyHost(parsedUrl.host());
            ret.setProxyPortInt(parsedUrl.port());
            if (this.proxyUser != null) {
                ret.setProxyUser(this.proxyUser);
            }
            if (this.proxyPassword != null) {
                ret.setProxyPass(this.proxyPassword);
            }
        }
        return this.configureHttpTestElement(ret);
    }

    protected abstract HTTPSamplerProxy configureHttpTestElement(HTTPSamplerProxy var1);

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        HashTree ret = super.buildTreeUnder(parent, context);
        if (!this.headers.isEmpty()) {
            context.buildChild(this.headers, ret);
        }
        new DslCookieManager().registerDependency(context);
        new DslCacheManager().registerDependency(context);
        return ret;
    }

    protected static abstract class BaseHttpSamplerCodeBuilder
    extends SingleGuiClassCallBuilder {
        private final String defaultName;

        protected BaseHttpSamplerCodeBuilder(String defaultName, Class<? extends JMeterGUIComponent> guiClass, List<Method> builderMethods) {
            super(guiClass, builderMethods);
            this.defaultName = defaultName;
        }

        @Override
        protected MethodCall buildMethodCall(MethodCallContext context) {
            HTTPSamplerProxy testElement = (HTTPSamplerProxy)context.getTestElement();
            TestElementParamBuilder paramBuilder = new TestElementParamBuilder((TestElement)testElement);
            MethodParam.StringParam name = paramBuilder.nameParam(this.defaultName);
            MethodParam.StringParam protocol = paramBuilder.stringParam("HTTPSampler.protocol");
            MethodParam.StringParam domain = paramBuilder.stringParam("HTTPSampler.domain");
            MethodParam.IntParam port = paramBuilder.intParam("HTTPSampler.port");
            MethodParam.StringParam path = paramBuilder.stringParam("HTTPSampler.path", "/");
            MethodParam.StringParam url = BaseHttpSamplerCodeBuilder.buildUrlParam(protocol, domain, new MethodParam.StringParam(port.isDefault() ? "" : "" + port.getValue()), path);
            MethodCall ret = this.buildBaseHttpMethodCall(name, url, paramBuilder);
            context.findBuilder(DslCacheManager.CodeBuilder.class).registerDependency(context, ret);
            context.findBuilder(DslCookieManager.CodeBuilder.class).registerDependency(context, ret);
            if (url.equals(path)) {
                ret.chain("protocol", protocol).chain("host", domain).chain("port", port);
            }
            this.buildRequestCall(ret, testElement, context);
            this.setAdditionalOptions(ret, paramBuilder);
            this.setProxyOptions(ret, paramBuilder);
            return ret;
        }

        protected abstract MethodCall buildBaseHttpMethodCall(MethodParam.StringParam var1, MethodParam.StringParam var2, TestElementParamBuilder var3);

        public static MethodParam.StringParam buildUrlParam(MethodParam.StringParam protocol, MethodParam.StringParam domain, MethodParam.StringParam port, MethodParam.StringParam path) {
            if (!domain.isDefault()) {
                return new MethodParam.StringParam(new JmeterUrl((String)protocol.getValue(), (String)domain.getValue(), (String)port.getValue(), path.isDefault() ? "" : (String)path.getValue()).toString());
            }
            return path;
        }

        protected abstract void buildRequestCall(MethodCall var1, HTTPSamplerProxy var2, MethodCallContext var3);

        protected String removeContentTypeHeader(MethodCallContext context) {
            if (context == null) {
                return null;
            }
            String headerName = "Content-Type";
            HeaderManager headers = (HeaderManager)context.getTestElement();
            Header header = headers.getFirstHeaderNamed(headerName);
            headers.removeHeaderNamed(headerName);
            return header == null ? null : header.getValue();
        }

        protected void chainContentType(MethodCall ret, String contentType) {
            ret.chain("contentType", new ContentTypeParam(contentType));
        }

        protected void chainHeaders(MethodCall ret, MethodCallContext headers) {
            if (headers != null) {
                ret.reChain(headers.buildMethodCall());
            }
        }

        protected abstract void setAdditionalOptions(MethodCall var1, TestElementParamBuilder var2);

        private void setProxyOptions(MethodCall ret, TestElementParamBuilder paramBuilder) {
            MethodParam.StringParam protocol = paramBuilder.stringParam("HTTPSampler.proxyScheme");
            MethodParam.StringParam host = paramBuilder.stringParam("HTTPSampler.proxyHost");
            MethodParam.IntParam port = paramBuilder.intParam("HTTPSampler.proxyPort");
            MethodParam.StringParam user = paramBuilder.stringParam("HTTPSampler.proxyUser");
            MethodParam.StringParam password = paramBuilder.stringParam("HTTPSampler.proxyPass");
            if (host.isDefault()) {
                return;
            }
            MethodParam.StringParam proxyUrl = BaseHttpSamplerCodeBuilder.buildUrlParam(protocol, host, new MethodParam.StringParam(port.isDefault() ? "" : "" + port.getValue()), new MethodParam.StringParam(""));
            if (user.isDefault()) {
                ret.chain("proxy", proxyUrl);
            } else {
                ret.chain("proxy", proxyUrl, user, password);
            }
        }
    }
}

