/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.nio.charset.Charset;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.config.gui.HttpDefaultsGui;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;
import us.abstracta.jmeter.javadsl.http.DslHttpSampler;
import us.abstracta.jmeter.javadsl.http.JmeterUrl;

public class DslHttpDefaults
extends BaseConfigElement {
    private String protocol;
    private String host;
    private String port;
    private String path;
    private Charset encoding;
    private boolean downloadEmbeddedResources;
    private DslHttpSampler.HttpClientImpl clientImpl;

    public DslHttpDefaults() {
        super("HTTP Request Defaults", HttpDefaultsGui.class);
    }

    public DslHttpDefaults url(String url) {
        JmeterUrl parsedUrl = JmeterUrl.valueOf(url);
        this.protocol = parsedUrl.protocol();
        this.host = parsedUrl.host();
        this.port = parsedUrl.port();
        this.path = parsedUrl.path();
        return this;
    }

    public DslHttpDefaults protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public DslHttpDefaults host(String host) {
        this.host = host;
        return this;
    }

    public DslHttpDefaults port(int port) {
        this.port = String.valueOf(port);
        return this;
    }

    public DslHttpDefaults path(String path) {
        this.path = path;
        return this;
    }

    public DslHttpDefaults encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public DslHttpDefaults downloadEmbeddedResources() {
        this.downloadEmbeddedResources = true;
        return this;
    }

    public DslHttpDefaults clientImpl(DslHttpSampler.HttpClientImpl clientImpl) {
        this.clientImpl = clientImpl;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        ConfigTestElement ret = new ConfigTestElement();
        if (this.protocol != null) {
            ret.setProperty("HTTPSampler.protocol", this.protocol);
        }
        if (this.host != null) {
            ret.setProperty("HTTPSampler.domain", this.host);
        }
        if (this.port != null) {
            ret.setProperty("HTTPSampler.port", this.port);
        }
        if (this.path != null) {
            ret.setProperty("HTTPSampler.path", this.path);
        }
        if (this.encoding != null) {
            ret.setProperty("HTTPSampler.contentEncoding", this.encoding.toString());
        }
        if (this.downloadEmbeddedResources) {
            ret.setProperty("HTTPSampler.image_parser", true);
            ret.setProperty("HTTPSampler.concurrentDwn", true);
        }
        if (this.clientImpl != null) {
            ret.setProperty("HTTPSampler.implementation", this.clientImpl.propertyValue);
        }
        return ret;
    }
}

