/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.entity.ContentType;
import us.abstracta.jmeter.javadsl.codegeneration.MethodCall;
import us.abstracta.jmeter.javadsl.codegeneration.MethodParam;

public class ContentTypeParam
extends MethodParam<ContentType> {
    private static final Map<ContentType, String> CONSTANT_CONTENT_TYPES = ContentTypeParam.findConstantNames(ContentType.class, ContentType.class, f -> !"DEFAULT_TEXT".equals(f.getName()) && !"DEFAULT_BINARY".equals(f.getName()));

    protected ContentTypeParam(String value) {
        super(ContentType.class, ContentType.parse((String)value), null);
    }

    @Override
    public String buildCode() {
        MethodParam[] methodParamArray;
        String contentTypeName = this.findConstantName((ContentType)this.value);
        if (contentTypeName != null) {
            return ContentType.class.getSimpleName() + "." + contentTypeName;
        }
        Charset charset = ((ContentType)this.value).getCharset();
        MethodParam.StringParam mimeTypeParam = new MethodParam.StringParam(((ContentType)this.value).getMimeType());
        if (charset != null) {
            MethodParam[] methodParamArray2 = new MethodParam[2];
            methodParamArray2[0] = mimeTypeParam;
            methodParamArray = methodParamArray2;
            methodParamArray2[1] = new MethodParam.StringParam(((ContentType)this.value).getCharset().name());
        } else {
            MethodParam[] methodParamArray3 = new MethodParam[1];
            methodParamArray = methodParamArray3;
            methodParamArray3[0] = mimeTypeParam;
        }
        MethodParam[] params = methodParamArray;
        return MethodCall.forStaticMethod(ContentType.class, "create", params).buildCode();
    }

    private String findConstantName(ContentType value) {
        return CONSTANT_CONTENT_TYPES.entrySet().stream().filter(entry -> ((ContentType)entry.getKey()).toString().equals(value.toString())).map(Map.Entry::getValue).findAny().orElse(null);
    }
}

