/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.engines;

import java.awt.Component;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.engines.EmbeddedStatsSummary;
import us.abstracta.jmeter.javadsl.core.engines.JmeterEnvironment;
import us.abstracta.jmeter.javadsl.core.listeners.DslVisualizer;

public class EmbeddedJmeterEngine
implements DslJmeterEngine {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedJmeterEngine.class);
    private final Map<String, Object> props = new HashMap<String, Object>();

    public EmbeddedJmeterEngine prop(String name, Object value) {
        this.props.put(name, value);
        return this;
    }

    @Override
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        return this.runInEnv(testPlan, new JmeterEnvironment());
    }

    protected TestPlanStats runInEnv(DslTestPlan testPlan, JmeterEnvironment env) {
        JMeterUtils.getJMeterProperties().putAll(this.props);
        ListedHashTree rootTree = new ListedHashTree();
        BuildTreeContext buildContext = new BuildTreeContext();
        HashTree testPlanTree = buildContext.buildTreeFor(testPlan, (HashTree)rootTree);
        TestPlanStats stats = new TestPlanStats(EmbeddedStatsSummary::new);
        this.addStatsCollector(testPlanTree, stats);
        testPlanTree.add((Object)new ResultCollector(new Summariser()));
        List<Future<Void>> closedVisualizers = Collections.emptyList();
        Map<DslVisualizer, Supplier<Component>> visualizers = buildContext.getVisualizers();
        if (!visualizers.isEmpty()) {
            env.initLocale();
            closedVisualizers = this.showVisualizers(visualizers);
        }
        Runnable testRunner = this.buildTestRunner(testPlanTree, (HashTree)rootTree);
        stats.setStart(Instant.now());
        testRunner.run();
        stats.setEnd(Instant.now());
        this.awaitAllClosedVisualizers(closedVisualizers);
        return stats;
    }

    protected void addStatsCollector(HashTree testPlanTree, final TestPlanStats stats) {
        ResultCollector collector = new ResultCollector();
        Visualizer statsVisualizer = new Visualizer(){

            public void add(SampleResult r) {
                stats.addSampleResult(r);
            }

            public boolean isStats() {
                return true;
            }
        };
        collector.setListener(statsVisualizer);
        testPlanTree.add((Object)collector);
        testPlanTree.add((Object)statsVisualizer);
    }

    protected Runnable buildTestRunner(HashTree testPlanTree, HashTree rootTree) {
        StandardJMeterEngine engine = new StandardJMeterEngine();
        engine.configure(rootTree);
        return engine;
    }

    private List<Future<Void>> showVisualizers(Map<DslVisualizer, Supplier<Component>> visualizers) {
        return visualizers.entrySet().stream().map(e -> {
            CompletableFuture closedVisualizer = new CompletableFuture();
            ((DslVisualizer)e.getKey()).showTestElementGui((Supplier)e.getValue(), () -> closedVisualizer.complete(null));
            return closedVisualizer;
        }).collect(Collectors.toList());
    }

    public void awaitAllClosedVisualizers(List<Future<Void>> closedVisualizers) {
        try {
            for (Future<Void> closedVisualizer : closedVisualizers) {
                try {
                    closedVisualizer.get();
                }
                catch (ExecutionException e) {
                    LOG.warn("Problem waiting for a visualizer to close", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

