/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.awt.GraphicsEnvironment;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;

public abstract class DslVisualizer
extends BaseTestElement
implements MultiLevelTestElement {
    private static final Logger LOG = LoggerFactory.getLogger(DslVisualizer.class);

    public DslVisualizer(String name, Class<? extends JMeterGUIComponent> guiClass) {
        super(name, guiClass);
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        if (GraphicsEnvironment.isHeadless()) {
            this.logNonGuiExecutionWarning();
            return parent;
        }
        TestElement testElement = this.buildConfiguredTestElement();
        HashTree ret = parent.add((Object)testElement);
        context.addVisualizer(this, () -> this.buildTestElementGui(testElement));
        return ret;
    }

    protected void logNonGuiExecutionWarning() {
        LOG.warn("The test plan contains a {} which is of no use in non GUI executions (like this one). Ignoring it for this execution. Remember removing them once your test plan is ready for load testing execution.", (Object)this.getClass().getSimpleName());
    }
}

