/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.dashboard.GenerationException;
import org.apache.jmeter.report.dashboard.ReportGenerator;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SimpleDataWriter;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;

public class HtmlReporter
extends BaseTestElement
implements MultiLevelTestElement {
    private final File reportDirectory;

    public HtmlReporter(String reportPath) throws IOException {
        super("Simple Data Writer", SimpleDataWriter.class);
        this.reportDirectory = new File(reportPath);
        if (this.reportDirectory.isFile()) {
            throw new FileAlreadyExistsException(reportPath);
        }
        if (this.reportDirectory.isDirectory() && !this.isEmptyDirectory(this.reportDirectory)) {
            throw new DirectoryNotEmptyException(reportPath);
        }
    }

    private boolean isEmptyDirectory(File reportDirectory) throws IOException {
        return !Files.newDirectoryStream(reportDirectory.toPath()).iterator().hasNext();
    }

    @Override
    public TestElement buildTestElement() {
        if (!this.reportDirectory.exists()) {
            this.reportDirectory.mkdirs();
        }
        File resultsFile = new File(this.reportDirectory, "report.jtl");
        HtmlReportSummariser reporter = new HtmlReportSummariser(resultsFile);
        AutoFlushingResultCollector logger = new AutoFlushingResultCollector(reporter);
        logger.setFilename(resultsFile.getPath());
        return logger;
    }

    public static class AutoFlushingResultCollector
    extends ResultCollector {
        public AutoFlushingResultCollector() {
        }

        public AutoFlushingResultCollector(Summariser summer) {
            super(summer);
        }

        public void testEnded(String host) {
            this.flushFile();
            super.testEnded(host);
        }
    }

    private static class HtmlReportSummariser
    extends Summariser {
        private final File resultsFile;
        private final AtomicInteger hostsCount = new AtomicInteger(0);

        private HtmlReportSummariser(File resultsFile) {
            this.resultsFile = resultsFile;
        }

        public void testStarted(String host) {
            super.testStarted(host);
            this.hostsCount.incrementAndGet();
        }

        public void sampleOccurred(SampleEvent e) {
        }

        public void testEnded(String host) {
            if (this.hostsCount.decrementAndGet() <= 0) {
                try {
                    JMeterUtils.setProperty((String)"jmeter.reportgenerator.outputdir", (String)new File(this.resultsFile.getParent()).getAbsolutePath());
                    new ReportGenerator(this.resultsFile.getPath(), null).generate();
                }
                catch (ConfigurationException | GenerationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

