/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.threadgroups;

import java.awt.Component;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.threads.UltimateThreadGroup;
import kg.apc.jmeter.threads.UltimateThreadGroupGui;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import us.abstracta.jmeter.javadsl.core.threadgroups.BaseThreadGroup;
import us.abstracta.jmeter.javadsl.core.util.SingleSeriesTimelinePanel;

public class DslThreadGroup
extends BaseThreadGroup<DslThreadGroup> {
    private final List<Stage> stages = new ArrayList<Stage>();

    public DslThreadGroup(String name, int threads, int iterations, List<BaseThreadGroup.ThreadGroupChild> children) {
        super(DslThreadGroup.solveName(name), (Class<? extends JMeterGUIComponent>)ThreadGroupGui.class, children);
        this.checkThreadCount(threads);
        if (iterations <= 0) {
            throw new IllegalArgumentException("Iterations must be >=1");
        }
        this.stages.add(new Stage(threads, Duration.ZERO));
        this.stages.add(new Stage(threads, iterations));
    }

    public DslThreadGroup(String name, int threads, Duration duration, List<BaseThreadGroup.ThreadGroupChild> children) {
        super(DslThreadGroup.solveName(name), (Class<? extends JMeterGUIComponent>)ThreadGroupGui.class, children);
        this.checkThreadCount(threads);
        this.stages.add(new Stage(threads, Duration.ZERO));
        this.stages.add(new Stage(threads, duration));
    }

    public DslThreadGroup(String name) {
        super(DslThreadGroup.solveName(name), (Class<? extends JMeterGUIComponent>)ThreadGroupGui.class, Collections.emptyList());
    }

    private static String solveName(String name) {
        return name != null ? name : "Thread Group";
    }

    private void checkThreadCount(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Threads count must be >=1");
        }
    }

    public DslThreadGroup rampTo(int threadCount, Duration duration) {
        if (threadCount < 0) {
            throw new IllegalArgumentException("Thread count must be >=0");
        }
        if (!this.stages.isEmpty() && this.getLastStage().duration == null) {
            throw new IllegalStateException("Ramping up/down after holding for iterations is not supported");
        }
        this.stages.add(new Stage(threadCount, duration));
        return this;
    }

    private Stage getLastStage() {
        return this.stages.get(this.stages.size() - 1);
    }

    public DslThreadGroup holdFor(Duration duration) {
        int threadsCount = this.stages.isEmpty() ? 0 : this.getLastStage().threadCount;
        this.stages.add(new Stage(threadsCount, duration));
        return this;
    }

    public DslThreadGroup holdIterating(int iterations) {
        if (iterations < 0) {
            throw new IllegalArgumentException("Iterations must be >=0");
        }
        if (!(this.stages.size() == 1 && this.stages.get(0).threadCount != 0 || this.stages.size() == 2 && this.stages.get(0).threadCount == 0 && this.stages.get(1).threadCount != 0)) {
            throw new IllegalStateException("Holding for iterations is only supported after initial hold and ramp, or ramp.");
        }
        this.stages.add(new Stage(this.getLastStage().threadCount, iterations));
        return this;
    }

    public DslThreadGroup rampToAndHold(int threads, Duration rampDuration, Duration holdDuration) {
        return this.rampTo(threads, rampDuration).holdFor(holdDuration);
    }

    @Override
    public DslThreadGroup children(BaseThreadGroup.ThreadGroupChild ... children) {
        return (DslThreadGroup)super.children(children);
    }

    @Override
    public AbstractThreadGroup buildThreadGroup() {
        return this.isSimpleThreadGroup() ? this.buildSimpleThreadGroup() : this.buildUltimateThreadGroup();
    }

    private boolean isSimpleThreadGroup() {
        return this.stages.size() <= 1 || this.stages.size() == 2 && (this.stages.get(0).threadCount == 0 || this.stages.get(0).threadCount == this.stages.get(1).threadCount) || this.stages.size() == 3 && this.stages.get(0).threadCount == 0 && this.stages.get(1).threadCount == this.stages.get(2).threadCount;
    }

    private AbstractThreadGroup buildSimpleThreadGroup() {
        int threads = 1;
        int iterations = 1;
        Duration rampUpPeriod = null;
        Duration duration = null;
        Duration delay = null;
        if (!this.stages.isEmpty()) {
            Stage firstStage = this.stages.get(0);
            if (firstStage.threadCount == 0) {
                delay = firstStage.duration;
            } else {
                rampUpPeriod = firstStage.duration;
                threads = firstStage.threadCount;
            }
            iterations = firstStage.iterations;
            if (this.stages.size() > 1) {
                Stage secondStage = this.stages.get(1);
                threads = secondStage.threadCount;
                iterations = secondStage.iterations;
                if (firstStage.threadCount == 0) {
                    rampUpPeriod = secondStage.duration;
                    if (this.stages.size() > 2) {
                        Stage lastStage = this.stages.get(2);
                        duration = lastStage.duration;
                        iterations = lastStage.iterations;
                    }
                } else {
                    duration = secondStage.duration;
                }
            }
        }
        return this.buildSimpleThreadGroup(threads, iterations, rampUpPeriod, duration, delay);
    }

    private ThreadGroup buildSimpleThreadGroup(int threads, int iterations, Duration rampUpPeriod, Duration duration, Duration delay) {
        ThreadGroup ret = new ThreadGroup();
        ret.setNumThreads(Math.max(threads, 1));
        ret.setRampUp((int)DslThreadGroup.durationToSeconds(rampUpPeriod == null ? Duration.ZERO : rampUpPeriod));
        LoopController loopController = new LoopController();
        ret.setSamplerController(loopController);
        if (duration != null) {
            loopController.setLoops(-1);
            ret.setDuration(DslThreadGroup.durationToSeconds(duration));
        } else {
            loopController.setLoops(iterations);
        }
        if (delay != null) {
            ret.setDelay(DslThreadGroup.durationToSeconds(delay));
        }
        if (duration != null || delay != null) {
            ret.setScheduler(true);
        }
        return ret;
    }

    private AbstractThreadGroup buildUltimateThreadGroup() {
        this.guiClass = UltimateThreadGroupGui.class;
        UltimateThreadGroup ret = new UltimateThreadGroup();
        PowerTableModel table = new PowerTableModel(UltimateThreadGroupGui.columnIdentifiers, UltimateThreadGroupGui.columnClasses);
        this.buildUltimateThreadGroupSchedules().forEach(s -> table.addRow(s.buildTableRow()));
        ret.setData(JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)table, (String)"ultimatethreadgroupdata"));
        LoopController loopController = new LoopController();
        loopController.setLoops(-1);
        loopController.setContinueForever(true);
        ret.setSamplerController(loopController);
        return ret;
    }

    private List<UltimateThreadSchedule> buildUltimateThreadGroupSchedules() {
        ArrayList<UltimateThreadSchedule> ret = new ArrayList<UltimateThreadSchedule>();
        Duration delay = Duration.ZERO;
        int threads = 0;
        Stack<UltimateThreadSchedule> stack = new Stack<UltimateThreadSchedule>();
        UltimateThreadSchedule curr = new UltimateThreadSchedule(0, Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO);
        for (Stage s : this.stages) {
            if (s.threadCount == threads) {
                curr.hold = curr.hold.plus(s.duration);
            } else if (s.threadCount > threads) {
                stack.add(curr);
                curr = new UltimateThreadSchedule(s.threadCount - threads, delay, s.duration, Duration.ZERO, Duration.ZERO);
            } else {
                int diff = threads - s.threadCount;
                Duration shutdown = s.duration;
                while (diff > curr.threadCount) {
                    curr.shutdown = DslThreadGroup.interpolateDurationForThreadCountWithRamp(curr.threadCount, diff, shutdown);
                    diff -= curr.threadCount;
                    shutdown = shutdown.minus(curr.shutdown);
                    curr = this.completeCurrentSchedule(curr, ret, stack);
                }
                if (diff == curr.threadCount) {
                    curr.shutdown = shutdown;
                } else {
                    Duration start = DslThreadGroup.interpolateDurationForThreadCountWithRamp(diff, curr.threadCount, curr.startup);
                    UltimateThreadSchedule last = curr;
                    curr = new UltimateThreadSchedule(diff, curr.delay.plus(curr.startup).minus(start), start, curr.hold, shutdown);
                    UltimateThreadSchedule ultimateThreadSchedule = last;
                    ultimateThreadSchedule.threadCount = ultimateThreadSchedule.threadCount - diff;
                    last.startup = last.startup.minus(start);
                    last.hold = Duration.ZERO;
                    stack.push(last);
                }
                curr = this.completeCurrentSchedule(curr, ret, stack);
            }
            threads = s.threadCount;
            delay = delay.plus(s.duration);
        }
        while (!stack.isEmpty()) {
            curr = this.completeCurrentSchedule(curr, ret, stack);
        }
        ret.sort(Comparator.comparing(r -> ((UltimateThreadSchedule)r).delay.toMillis()));
        return ret;
    }

    private static Duration interpolateDurationForThreadCountWithRamp(int threadCount, int rampThreads, Duration rampDuration) {
        return Duration.ofMillis((long)((double)rampDuration.toMillis() * ((double)threadCount / (double)rampThreads)));
    }

    private UltimateThreadSchedule completeCurrentSchedule(UltimateThreadSchedule curr, List<UltimateThreadSchedule> ret, Stack<UltimateThreadSchedule> stack) {
        ret.add(curr);
        UltimateThreadSchedule last = curr;
        curr = stack.pop();
        curr.hold = curr.hold.plus(last.startup).plus(last.hold).plus(last.shutdown);
        return curr;
    }

    @Deprecated
    public void showThreadsTimeline() {
        this.showTimeline();
    }

    public void showTimeline() {
        SingleSeriesTimelinePanel chart = new SingleSeriesTimelinePanel("Threads");
        chart.add(0L, 0.0);
        this.stages.forEach(s -> chart.add(((Stage)s).duration.toMillis(), ((Stage)s).threadCount));
        this.showFrameWith((Component)((Object)chart), this.name + " threads timeline", 800, 300, null);
    }

    protected static class UltimateThreadSchedule {
        private int threadCount;
        private final Duration delay;
        private Duration startup;
        private Duration hold;
        private Duration shutdown;

        public UltimateThreadSchedule(int threadCount, Duration delay, Duration startup, Duration hold, Duration shutdown) {
            this.threadCount = threadCount;
            this.delay = delay;
            this.startup = startup;
            this.hold = hold;
            this.shutdown = shutdown;
        }

        public Object[] buildTableRow() {
            return new Object[]{String.valueOf(this.threadCount), String.valueOf(DslThreadGroup.durationToSeconds(this.delay)), String.valueOf(DslThreadGroup.durationToSeconds(this.startup)), String.valueOf(DslThreadGroup.durationToSeconds(this.hold)), String.valueOf(DslThreadGroup.durationToSeconds(this.shutdown))};
        }
    }

    private static class Stage {
        private final int threadCount;
        private final Duration duration;
        private final int iterations;

        private Stage(int threadCount, Duration duration) {
            this.threadCount = threadCount;
            this.duration = duration;
            this.iterations = 0;
        }

        private Stage(int threadCount, int iterations) {
            this.threadCount = threadCount;
            this.iterations = iterations;
            this.duration = null;
        }
    }
}

