/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.engines;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Collectors;
import kg.apc.jmeter.timers.functions.TSTFeedback;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.functions.EvalFunction;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jorphan.collections.HashTree;

public class JMeterEnvironment
implements Closeable {
    private final File homeDir = Files.createTempDirectory("jmeter-java-dsl", new FileAttribute[0]).toFile();

    public JMeterEnvironment() throws IOException {
        try {
            JMeterUtils.setJMeterHome((String)this.homeDir.getPath());
            File binDir = new File(this.homeDir, "bin");
            this.installConfig(binDir);
            Properties props = JMeterUtils.getProperties((String)new File(binDir, "jmeter.properties").getPath());
            props.setProperty("search_paths", this.buildJarPathsFromClasses(EvalFunction.class, BackendListenerClient.class, TSTFeedback.class));
        }
        catch (IOException | RuntimeException e) {
            FileUtils.deleteDirectory((File)this.homeDir);
            throw e;
        }
    }

    private String buildJarPathsFromClasses(Class<?> ... classes) {
        return Arrays.stream(classes).map(this::getClassJarPath).collect(Collectors.joining(";"));
    }

    private String getClassJarPath(Class<?> theClass) {
        try {
            return new File(theClass.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void installConfig(File binDir) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(this.getClass().getResource("/bin/jmeter.properties").toURI(), Collections.emptyMap());){
            Path configBinDir = fs.getPath("/bin", new String[0]);
            for (Path p : Files.walk(configBinDir, new FileVisitOption[0])::iterator) {
                Path targetPath = binDir.toPath().resolve(configBinDir.relativize(p).toString());
                Files.copy(p, targetPath, new CopyOption[0]);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveTree(HashTree tree, FileOutputStream output) throws IOException {
        SaveService.saveTree((HashTree)tree, (OutputStream)output);
    }

    public HashTree loadTree(File file) throws IOException {
        return SaveService.loadTree((File)file);
    }

    public void initLocale() {
        JMeterUtils.initLocale();
    }

    @Override
    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this.homeDir);
    }
}

