/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.visualizers.backend.BackendListener;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerGui;
import us.abstracta.jmeter.javadsl.core.testelements.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.testelements.MultiLevelTestElement;

public abstract class DslBackendListener
extends BaseTestElement
implements MultiLevelTestElement {
    protected final String url;
    private final Class<? extends BackendListenerClient> listenerClass;
    private int queueSize = 5000;

    protected DslBackendListener(Class<? extends BackendListenerClient> listenerClass, String url) {
        super("Backend Listener", BackendListenerGui.class);
        this.url = url;
        this.listenerClass = listenerClass;
    }

    protected void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    @Override
    protected TestElement buildTestElement() {
        BackendListener ret = new BackendListener();
        ret.setClassname(this.listenerClass.getName());
        ret.setQueueSize(String.valueOf(this.queueSize));
        ret.setArguments(this.buildArguments());
        return ret;
    }

    private Arguments buildArguments() {
        try {
            Arguments ret = this.listenerClass.newInstance().getDefaultParameters();
            this.addAllArguments(this.buildListenerArguments(), ret);
            return ret;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Arguments buildListenerArguments();

    private void addAllArguments(Arguments args, Arguments ret) {
        for (JMeterProperty prop : args) {
            Argument arg = (Argument)prop.getObjectValue();
            ret.removeArgument(arg.getName());
            ret.addArgument(arg.getName(), arg.getValue());
        }
    }
}

