/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.function.Supplier;
import javax.swing.JFrame;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestElement;
import us.abstracta.jmeter.javadsl.core.EmbeddedJmeterEngine;

public abstract class BaseTestElement
implements DslTestElement {
    protected final String name;
    protected Class<? extends JMeterGUIComponent> guiClass;

    protected BaseTestElement(String name, Class<? extends JMeterGUIComponent> guiClass) {
        this.name = name;
        this.guiClass = guiClass;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        return parent.add((Object)this.buildConfiguredTestElement());
    }

    protected TestElement buildConfiguredTestElement() {
        TestElement ret = this.buildTestElement();
        ret.setName(this.name);
        ret.setProperty("TestElement.gui_class", this.guiClass.getName());
        ret.setProperty("TestElement.test_class", ret.getClass().getName());
        return ret;
    }

    protected abstract TestElement buildTestElement();

    @Override
    public void showInGui() {
        try (EmbeddedJmeterEngine.JMeterEnvironment env = new EmbeddedJmeterEngine.JMeterEnvironment();){
            env.initLocale();
            this.showTestElementGui(() -> this.buildTestElementGui(this.buildConfiguredTestElement()), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Component buildTestElementGui(TestElement testElement) {
        try {
            Class<?> guiClass = Class.forName(testElement.getPropertyAsString("TestElement.gui_class"));
            TestBeanGUI gui = guiClass == TestBeanGUI.class ? new TestBeanGUI(testElement.getClass()) : (JMeterGUIComponent)guiClass.newInstance();
            gui.clearGui();
            gui.configure(testElement);
            gui.modifyTestElement(testElement);
            return (Component)gui;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void showTestElementGui(Supplier<Component> guiBuilder, Runnable closeListener) {
        this.showFrameWith(guiBuilder.get(), this.name, 800, 600, closeListener);
    }

    protected void showFrameWith(Component content, String title, int width, int height, final Runnable closeListener) {
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(closeListener != null ? 2 : 3);
        if (closeListener != null) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    closeListener.run();
                }
            });
        }
        frame.setLocation(200, 200);
        frame.setSize(width, height);
        frame.add(content);
        frame.setVisible(true);
    }
}

