/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildTreeContext {
    private static final Logger LOG = LoggerFactory.getLogger(BuildTreeContext.class);
    private final HashTree root;
    private final Map<String, Object> entries = new HashMap<String, Object>();
    private final List<Future<Void>> visualizersClose = new ArrayList<Future<Void>>();

    public BuildTreeContext(HashTree root) {
        this.root = root;
    }

    public HashTree getTestPlanTree() {
        return (HashTree)this.root.values().iterator().next();
    }

    public Object getEntry(String key) {
        return this.entries.get(key);
    }

    public void setEntry(String key, Object value) {
        this.entries.put(key, value);
    }

    public void addVisualizerCloseFuture(Future<Void> future) {
        this.visualizersClose.add(future);
    }

    public void awaitAllVisualizersClosed() {
        try {
            for (Future<Void> visualizerClose : this.visualizersClose) {
                try {
                    visualizerClose.get();
                }
                catch (ExecutionException e) {
                    LOG.warn("Problem waiting for a visualizer to close", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

