/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.functions.EvalFunction;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import us.abstracta.jmeter.javadsl.core.AggregatingTestPlanStats;
import us.abstracta.jmeter.javadsl.core.DslJmeterEngine;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;

public class EmbeddedJmeterEngine
implements DslJmeterEngine {
    @Override
    public TestPlanStats run(DslTestPlan testPlan) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();){
            StandardJMeterEngine engine = new StandardJMeterEngine();
            HashTree rootTree = new HashTree();
            HashTree testPlanTree = testPlan.buildTreeUnder(rootTree);
            AggregatingTestPlanStats stats = new AggregatingTestPlanStats();
            this.addTestStatsCollectorToTree(stats, testPlanTree);
            this.addTestSummariserToTree(testPlanTree);
            engine.configure(rootTree);
            engine.run();
            AggregatingTestPlanStats aggregatingTestPlanStats = stats;
            return aggregatingTestPlanStats;
        }
    }

    private void addTestStatsCollectorToTree(final AggregatingTestPlanStats stats, HashTree tree) {
        ResultCollector collector = new ResultCollector();
        Visualizer statsVisualizer = new Visualizer(){

            public void add(SampleResult r) {
                stats.addSampleResult(r);
            }

            public boolean isStats() {
                return true;
            }
        };
        collector.setListener(statsVisualizer);
        tree.add((Object)collector);
        tree.add((Object)statsVisualizer);
    }

    private void addTestSummariserToTree(HashTree tree) {
        tree.add((Object)new ResultCollector(new Summariser()));
    }

    public void saveToJmx(String filePath, DslTestPlan dslTestPlan) throws IOException {
        try (JMeterEnvironment env = new JMeterEnvironment();
             FileOutputStream output = new FileOutputStream(filePath);){
            ListedHashTree tree = new ListedHashTree();
            dslTestPlan.buildTreeUnder((HashTree)tree);
            SaveService.saveTree((HashTree)tree, (OutputStream)output);
        }
    }

    private static class JMeterEnvironment
    implements Closeable {
        private final Path propsFilePath = Files.createTempFile("jmeter", ".properties", new FileAttribute[0]);

        private JMeterEnvironment() throws IOException {
            try {
                this.setupJMeterProperties(this.propsFilePath);
            }
            catch (IOException | RuntimeException e) {
                this.deleteFile(this.propsFilePath);
                throw e;
            }
        }

        private void setupJMeterProperties(Path propsFilePath) throws IOException {
            this.deleteFile(propsFilePath);
            Files.copy(this.getClass().getResourceAsStream("/saveservice.properties"), propsFilePath, new CopyOption[0]);
            JMeterUtils.loadJMeterProperties((String)propsFilePath.toString());
            JMeterUtils.setProperty((String)"search_paths", (String)this.getFunctionsJarPath());
            JMeterUtils.setProperty((String)"saveservice_properties", (String)propsFilePath.toString());
        }

        private void deleteFile(Path propsFilePath) {
            propsFilePath.toFile().delete();
        }

        private String getFunctionsJarPath() {
            try {
                return new File(EvalFunction.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            this.deleteFile(this.propsFilePath);
        }
    }
}

