/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.listeners;

import java.awt.GraphicsEnvironment;
import java.util.concurrent.CompletableFuture;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.core.BaseTestElement;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.MultiLevelTestElement;

public class DslViewResultsTree
extends BaseTestElement
implements MultiLevelTestElement {
    private static final Logger LOG = LoggerFactory.getLogger(DslViewResultsTree.class);
    private static final String MAX_RESULTS_PROPERTY_NAME = "view.results.tree.max_results";
    private int resultsLimit;

    public DslViewResultsTree() {
        super("View Results Tree", ViewResultsFullVisualizer.class);
    }

    public DslViewResultsTree resultsLimit(int resultsLimit) {
        this.resultsLimit = resultsLimit;
        return this;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent, BuildTreeContext context) {
        if (GraphicsEnvironment.isHeadless()) {
            LOG.warn("The test plan contains a View Results Tree which is of no use in non GUI executions (like this one). Ignoring it for this execution. Remember removing them once your test plan is ready for load testing execution.");
            return parent;
        }
        TestElement testElement = this.buildConfiguredTestElement();
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        context.addVisualizerCloseFuture(closeFuture);
        int prevLimit = JMeterUtils.getPropDefault((String)MAX_RESULTS_PROPERTY_NAME, (int)500);
        JMeterUtils.setProperty((String)MAX_RESULTS_PROPERTY_NAME, (String)String.valueOf(this.resultsLimit));
        this.showTestElementInGui(testElement, () -> closeFuture.complete(null));
        JMeterUtils.setProperty((String)MAX_RESULTS_PROPERTY_NAME, (String)String.valueOf(prevLimit));
        return parent.add((Object)testElement);
    }

    @Override
    protected TestElement buildTestElement() {
        return new ResultCollector();
    }
}

