/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core.postprocessors;

import java.util.function.Consumer;
import org.apache.jmeter.extractor.RegexExtractor;
import org.apache.jmeter.extractor.gui.RegexExtractorGui;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.DslScopedTestElement;
import us.abstracta.jmeter.javadsl.core.MultiLevelTestElement;

public class DslRegexExtractor
extends DslScopedTestElement<DslRegexExtractor>
implements MultiLevelTestElement {
    private final String variableName;
    private final String regex;
    private int matchNumber = 1;
    private String template = "$1$";
    private String defaultValue;
    private TargetField fieldToCheck = TargetField.RESPONSE_BODY;

    public DslRegexExtractor(String variableName, String regex) {
        super("name", RegexExtractorGui.class);
        this.variableName = variableName;
        this.regex = regex;
    }

    public DslRegexExtractor matchNumber(int matchNumber) {
        this.matchNumber = matchNumber;
        return this;
    }

    public DslRegexExtractor template(String template) {
        this.template = template;
        return this;
    }

    public DslRegexExtractor defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DslRegexExtractor fieldToCheck(TargetField fieldToCheck) {
        this.fieldToCheck = fieldToCheck;
        return this;
    }

    @Override
    protected TestElement buildTestElement() {
        RegexExtractor ret = new RegexExtractor();
        this.setScopeTo((AbstractScopedTestElement)ret);
        this.fieldToCheck.applyTo(ret);
        ret.setRefName(this.variableName);
        ret.setRegex(this.regex);
        ret.setMatchNumber(this.matchNumber);
        ret.setTemplate(this.template);
        if (this.defaultValue != null) {
            if (this.defaultValue.isEmpty()) {
                ret.setDefaultEmptyValue(true);
            } else {
                ret.setDefaultValue(this.defaultValue);
            }
        }
        return ret;
    }

    public static enum TargetField {
        RESPONSE_BODY(RegexExtractor::useBody),
        RESPONSE_BODY_UNESCAPED(RegexExtractor::useUnescapedBody),
        RESPONSE_BODY_AS_DOCUMENT(RegexExtractor::useBodyAsDocument),
        RESPONSE_HEADERS(RegexExtractor::useHeaders),
        REQUEST_HEADERS(RegexExtractor::useRequestHeaders),
        REQUEST_URL(RegexExtractor::useUrl),
        RESPONSE_CODE(RegexExtractor::useCode),
        RESPONSE_MESSAGE(RegexExtractor::useMessage);

        private final Consumer<RegexExtractor> applier;

        private TargetField(Consumer<RegexExtractor> applier) {
            this.applier = applier;
        }

        private void applyTo(RegexExtractor re) {
            this.applier.accept(re);
        }
    }
}

