/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.http;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import us.abstracta.jmeter.javadsl.JmeterDsl;
import us.abstracta.jmeter.javadsl.core.DslSampler;
import us.abstracta.jmeter.javadsl.core.preprocessors.DslJsr223PreProcessor;
import us.abstracta.jmeter.javadsl.http.HttpHeaders;

public class DslHttpSampler
extends DslSampler {
    private final String url;
    private HttpMethod method = HttpMethod.GET;
    private final HttpHeaders headers = new HttpHeaders();
    private String body;

    public DslHttpSampler(String name, String url) {
        super(DslHttpSampler.buildName(name), (Class<? extends JMeterGUIComponent>)HttpTestSampleGui.class, (List<DslSampler.SamplerChild>)new ArrayList<DslSampler.SamplerChild>());
        this.url = url;
    }

    public DslHttpSampler(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> urlSupplier) {
        super(DslHttpSampler.buildName(name), (Class<? extends JMeterGUIComponent>)HttpTestSampleGui.class, (List<DslSampler.SamplerChild>)new ArrayList<DslSampler.SamplerChild>());
        String variableName = "PRE_PROCESSOR_URL";
        this.url = "${" + variableName + "}";
        this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)urlSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    private static String buildName(String name) {
        return name != null ? name : "HTTP Request";
    }

    public DslHttpSampler post(String body, MimeTypes.Type contentType) {
        return this.method(HttpMethod.POST).contentType(contentType).body(body);
    }

    public DslHttpSampler post(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier, MimeTypes.Type contentType) {
        return this.method(HttpMethod.POST).contentType(contentType).body(bodySupplier);
    }

    public DslHttpSampler method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public DslHttpSampler header(String name, String value) {
        this.headers.header(name, value);
        return this;
    }

    public DslHttpSampler header(String name, Function<DslJsr223PreProcessor.PreProcessorVars, String> valueSupplier) {
        String variableNamePrefix = "PRE_PROCESSOR_HEADER~";
        this.headers.header(name, "${" + variableNamePrefix + name + "}");
        return this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableNamePrefix + name, (String)valueSupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler contentType(MimeTypes.Type contentType) {
        this.headers.contentType(contentType);
        return this;
    }

    public DslHttpSampler body(String body) {
        this.body = body;
        return this;
    }

    public DslHttpSampler body(Function<DslJsr223PreProcessor.PreProcessorVars, String> bodySupplier) {
        String variableName = "PRE_PROCESSOR_REQUEST_BODY";
        this.body = "${" + variableName + "}";
        return this.children(JmeterDsl.jsr223PreProcessor(s -> s.vars.put(variableName, (String)bodySupplier.apply((DslJsr223PreProcessor.PreProcessorVars)s))));
    }

    public DslHttpSampler children(DslSampler.SamplerChild ... children) {
        for (DslSampler.SamplerChild child : children) {
            this.addChild(child);
        }
        return this;
    }

    @Override
    public TestElement buildTestElement() {
        HTTPSamplerProxy ret = new HTTPSamplerProxy();
        ret.setFollowRedirects(true);
        ret.setUseKeepAlive(true);
        ret.setPath(this.url);
        ret.setMethod(this.method.name());
        ret.setArguments(this.buildArguments());
        return ret;
    }

    private Arguments buildArguments() {
        Arguments args = new Arguments();
        if (this.body != null) {
            HTTPArgument arg = new HTTPArgument("", this.body, false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        }
        return args;
    }

    @Override
    public HashTree buildTreeUnder(HashTree parent) {
        HashTree ret = super.buildTreeUnder(parent);
        if (!this.headers.isEmpty()) {
            this.headers.buildTreeUnder(ret);
        }
        return ret;
    }
}

