/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.report.processor.StatisticsSummaryData;
import org.apache.jmeter.samplers.SampleResult;

public class TestPlanStats {
    private final StatsSummary overallStats = new StatsSummary();
    private final Map<String, StatsSummary> labeledStats = new ConcurrentHashMap<String, StatsSummary>();

    public void addSampleResult(SampleResult result) {
        this.overallStats.addResult(result);
        this.labeledStats.computeIfAbsent(result.getSampleLabel(), label -> new StatsSummary()).addResult(result);
    }

    public StatsSummary overall() {
        return this.overallStats;
    }

    public StatsSummary byLabel(String label) {
        return this.labeledStats.get(label);
    }

    public Set<String> labels() {
        return this.labeledStats.keySet();
    }

    public static class StatsSummary {
        private final StatisticsSummaryData stats = new StatisticsSummaryData(90L, 95L, 99L);

        private void addResult(SampleResult result) {
            this.stats.incTotal();
            this.stats.incBytes(result.getBytesAsLong());
            this.stats.incSentBytes(result.getSentBytes());
            if (!result.isSuccessful()) {
                this.stats.incErrors();
            }
            this.updateElapsedTime(result.getTime());
            this.stats.setFirstTime(result.getStartTime());
            this.stats.setEndTime(result.getEndTime());
        }

        private void updateElapsedTime(long elapsedTime) {
            this.stats.getPercentile1().addValue((double)elapsedTime);
            this.stats.getPercentile2().addValue((double)elapsedTime);
            this.stats.getPercentile3().addValue((double)elapsedTime);
            this.stats.getMean().addValue((double)elapsedTime);
            this.stats.setMin(elapsedTime);
            this.stats.setMax(elapsedTime);
        }

        public Instant firstTime() {
            return Instant.ofEpochMilli(this.stats.getFirstTime());
        }

        public Instant endTime() {
            return Instant.ofEpochMilli(this.stats.getEndTime());
        }

        public Duration elapsedTime() {
            return Duration.ofMillis(this.stats.getElapsedTime());
        }

        public long samplesCount() {
            return this.stats.getTotal();
        }

        public double samplesPerSecond() {
            return this.stats.getThroughput();
        }

        public long errorsCount() {
            return this.stats.getErrors();
        }

        public Duration minElapsedTime() {
            return Duration.ofMillis(this.stats.getMin());
        }

        public Duration maxElapsedTime() {
            return Duration.ofMillis(this.stats.getMax());
        }

        public Duration meanElapsedTime() {
            return Duration.ofMillis((long)this.stats.getMean().getResult());
        }

        public Duration elapsedTimePercentile90() {
            return Duration.ofMillis((long)this.stats.getPercentile1().getResult());
        }

        public Duration elapsedTimePercentile95() {
            return Duration.ofMillis((long)this.stats.getPercentile2().getResult());
        }

        public Duration elapsedTimePercentile99() {
            return Duration.ofMillis((long)this.stats.getPercentile3().getResult());
        }

        public long receivedBytes() {
            return this.stats.getBytes();
        }

        public double receivedBytesPerSecond() {
            return this.stats.getBytesPerSecond();
        }

        public long sentBytes() {
            return this.stats.getSentBytes();
        }

        public double sentBytesPerSecond() {
            return this.stats.getSentBytesPerSecond();
        }
    }
}

