/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.jdbc;

import java.lang.reflect.Field;
import java.sql.Types;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jmeter.protocol.jdbc.sampler.JDBCSampler;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.samplers.BaseSampler;

public class DslJdbcSampler
extends BaseSampler<DslJdbcSampler> {
    private final String poolName;
    private final String query;
    private final List<QueryParameter> params = new ArrayList<QueryParameter>();
    private final List<String> vars = new ArrayList<String>();
    private String resultsVar;
    private Duration timeout;
    private QueryType queryType;

    public DslJdbcSampler(String name, String poolName, String query) {
        super(name != null ? name : "", TestBeanGUI.class);
        this.poolName = poolName;
        this.query = query;
    }

    public DslJdbcSampler param(Object value, int jdbcParamType) {
        return this.param(value, jdbcParamType, JdbcParamMode.IN);
    }

    public DslJdbcSampler param(Object value, int jdbcParamType, JdbcParamMode mode) {
        this.params.add(new QueryParameter(value, jdbcParamType, mode));
        return this;
    }

    public DslJdbcSampler vars(String ... vars) {
        this.vars.addAll(Arrays.asList(vars));
        return this;
    }

    public DslJdbcSampler resultsVar(String resultsVar) {
        this.resultsVar = resultsVar;
        return this;
    }

    public DslJdbcSampler timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public DslJdbcSampler commit() {
        this.queryType = QueryType.COMMIT;
        return this;
    }

    public DslJdbcSampler rollback() {
        this.queryType = QueryType.ROLLBACK;
        return this;
    }

    public DslJdbcSampler autoCommit(boolean enabled) {
        this.queryType = enabled ? QueryType.AUTO_COMMIT_TRUE : QueryType.AUTO_COMMIT_FALSE;
        return this;
    }

    public DslJdbcSampler queryType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    protected TestElement buildTestElement() {
        JDBCSampler ret = new JDBCSampler();
        ret.setQueryType(this.getQueryType().propertyValue);
        ret.setDataSource(this.poolName);
        ret.setQuery(this.query);
        ret.setQueryArguments(this.params.stream().map(this::extractParamValue).collect(Collectors.joining(",")));
        ret.setQueryArgumentsTypes(this.params.stream().map(rec$ -> ((QueryParameter)rec$).getTypePropertyValue()).collect(Collectors.joining(",")));
        ret.setVariableNames(String.join((CharSequence)",", this.vars));
        ret.setResultVariable(this.resultsVar);
        ret.setQueryTimeout(this.timeout != null ? String.valueOf(DslJdbcSampler.durationToSeconds((Duration)this.timeout)) : "-1");
        return ret;
    }

    private QueryType getQueryType() {
        if (this.queryType != null) {
            return this.queryType;
        }
        if (this.query == null) {
            throw new IllegalStateException("Query can only be null when using commit, rollback or autoCommit");
        }
        String queryType = this.query.trim();
        if ("select".equals(queryType = queryType.substring(0, queryType.indexOf(" ")).toLowerCase(Locale.US))) {
            return this.params.isEmpty() ? QueryType.SELECT : QueryType.PREPARED_SELECT;
        }
        if ("insert".equals(queryType) || "update".equals(queryType) || "delete".equals(queryType)) {
            return this.params.isEmpty() ? QueryType.UPDATE : QueryType.PREPARED_UPDATE;
        }
        return QueryType.CALLABLE;
    }

    private String extractParamValue(QueryParameter p) {
        if (p.value == null) {
            return "]NULL[";
        }
        String strValue = p.value.toString();
        if (strValue.contains(",") || strValue.contains("\"")) {
            return "\"" + strValue.replace("\"", "\"\"") + "\"";
        }
        return strValue;
    }

    public static enum QueryType {
        SELECT("Select Statement"),
        UPDATE("Update Statement"),
        CALLABLE("Callable Statement"),
        PREPARED_SELECT("Prepared Select Statement"),
        PREPARED_UPDATE("Prepared Update Statement"),
        COMMIT("Commit"),
        ROLLBACK("Rollback"),
        AUTO_COMMIT_FALSE("AutoCommit(false)"),
        AUTO_COMMIT_TRUE("AutoCommit(true)");

        private final String propertyValue;

        private QueryType(String propertyValue) {
            this.propertyValue = propertyValue;
        }
    }

    public static enum JdbcParamMode {
        IN,
        OUT,
        INOUT;

    }

    private static class QueryParameter {
        private static final Map<Integer, String> JDBC_TYPE_TO_PROPERTY_VALUE = QueryParameter.buildJdbcTypeToPropertyValueMapping();
        private final Object value;
        private final int jdbcType;
        private final JdbcParamMode mode;

        private QueryParameter(Object value, int jdbcType, JdbcParamMode mode) {
            this.value = value;
            this.jdbcType = jdbcType;
            this.mode = mode;
        }

        private static Map<Integer, String> buildJdbcTypeToPropertyValueMapping() {
            HashMap<Integer, String> ret = new HashMap<Integer, String>();
            Field[] fields = Types.class.getFields();
            try {
                for (Field field : fields) {
                    String name = field.getName();
                    Integer value = (Integer)field.get(null);
                    ret.put(value, name.toLowerCase(Locale.ENGLISH));
                }
                return ret;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private String getTypePropertyValue() {
            String propVal = JDBC_TYPE_TO_PROPERTY_VALUE.get(this.jdbcType);
            if (propVal == null) {
                propVal = String.valueOf(this.jdbcType);
            }
            return this.mode == JdbcParamMode.IN ? propVal : this.mode.name() + " " + propVal;
        }
    }
}

